/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.skyworld;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Collection;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.schema.SchemaRegistry;
import org.dave.compactmachines3.skyworld.EnumSkyWorldSize;

public class SkyWorldConfiguration {
    public Schema schema;
    public boolean startLocked;
    public boolean givePSD;
    public EnumSkyWorldSize size;

    public SkyWorldConfiguration() {
        Collection<Schema> allSchemas = SchemaRegistry.instance.getSchemas();
        this.schema = allSchemas.stream().findFirst().orElse(null);
        this.startLocked = true;
        this.givePSD = true;
        this.size = EnumSkyWorldSize.SMALL;
    }

    public SkyWorldConfiguration(String chunkProviderSettingsJson) {
        this();
        String schemaName;
        JsonParser myParser = new JsonParser();
        JsonElement rootElement = myParser.parse(chunkProviderSettingsJson);
        if (!rootElement.isJsonObject()) {
            return;
        }
        JsonObject rootObject = rootElement.getAsJsonObject();
        if (rootObject.has("startLocked")) {
            this.startLocked = rootObject.get("startLocked").getAsBoolean();
        }
        if (rootObject.has("schema") && SchemaRegistry.instance.hasSchema(schemaName = rootObject.get("schema").getAsString())) {
            this.schema = SchemaRegistry.instance.getSchema(schemaName);
        }
        if (rootObject.has("givePSD")) {
            this.givePSD = rootObject.get("givePSD").getAsBoolean();
        }
        if (rootObject.has("size")) {
            String size = rootObject.get("size").getAsString();
            if (!Arrays.stream(EnumSkyWorldSize.values()).anyMatch(s -> s.name().equals(size))) {
                CompactMachines3.logger.warn("Invalid size value specified: {}. Falling back to SMALL.", (Object)size);
                this.size = EnumSkyWorldSize.SMALL;
            } else {
                this.size = EnumSkyWorldSize.valueOf(size);
            }
        }
    }

    public String getAsJsonString() {
        JsonObject rootObject = new JsonObject();
        if (this.schema != null) {
            rootObject.add("schema", (JsonElement)new JsonPrimitive(this.schema.getName()));
        }
        rootObject.add("startLocked", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.startLocked)));
        rootObject.add("givePSD", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.givePSD)));
        rootObject.add("size", (JsonElement)new JsonPrimitive(this.size.name()));
        return rootObject.toString();
    }
}

