/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.schema.BlockInformation;

public class BlockInformationSerializer
implements JsonSerializer<BlockInformation>,
JsonDeserializer<BlockInformation> {
    private static JsonElement NbtToJson(NBTTagCompound tag) {
        Set keys = tag.func_150296_c();
        JsonObject jsonRoot = new JsonObject();
        for (String key : keys) {
            JsonArray array;
            JsonElement element;
            NBTBase nbt = tag.func_74781_a(key);
            if (nbt instanceof NBTTagCompound) {
                element = BlockInformationSerializer.NbtToJson((NBTTagCompound)nbt);
            } else if (nbt instanceof NBTPrimitive) {
                String NBTType = NBTBase.field_82578_b[nbt.func_74732_a()];
                element = NBTType.equals("BYTE") ? new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150290_f()) : (NBTType.equals("SHORT") ? new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150289_e()) : (NBTType.equals("INT") ? new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150287_d()) : (NBTType.equals("LONG") ? new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150291_c()) : (NBTType.equals("FLOAT") ? new JsonPrimitive((Number)Float.valueOf(((NBTPrimitive)nbt).func_150288_h())) : (NBTType.equals("DOUBLE") ? new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150286_g()) : new JsonPrimitive((Number)((NBTPrimitive)nbt).func_150286_g()))))));
            } else if (nbt instanceof NBTTagString) {
                element = new JsonPrimitive(((NBTTagString)nbt).func_150285_a_());
            } else if (nbt instanceof NBTTagList) {
                NBTTagList tagList = (NBTTagList)nbt;
                array = new JsonArray();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    array.add(BlockInformationSerializer.NbtToJson(tagList.func_150305_b(i)));
                }
                element = array;
            } else if (nbt instanceof NBTTagIntArray) {
                int[] intArray = ((NBTTagIntArray)nbt).func_150302_c();
                array = new JsonArray();
                for (byte by : intArray) {
                    array.add((JsonElement)new JsonPrimitive((Number)by));
                }
                element = array;
            } else if (nbt instanceof NBTTagByteArray) {
                byte[] byteArray = ((NBTTagByteArray)nbt).func_150292_c();
                array = new JsonArray();
                for (byte by : byteArray) {
                    array.add((JsonElement)new JsonPrimitive((Number)by));
                }
                element = array;
            } else {
                CompactMachines3.logger.info("{} no support for: {}", (Object)nbt, (Object)NBTBase.field_82578_b[nbt.func_74732_a()]);
                throw new IllegalArgumentException(String.format("NBTtoJSON doesn't support nbt base type=%s, tag=%s", NBTBase.field_82578_b[nbt.func_74732_a()], nbt));
            }
            jsonRoot.add(key, element);
        }
        return jsonRoot;
    }

    public JsonElement serialize(BlockInformation src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject root = new JsonObject();
        root.addProperty("block", src.block.getRegistryName().toString());
        root.addProperty("x", (Number)src.position.func_177958_n());
        root.addProperty("y", (Number)src.position.func_177956_o());
        root.addProperty("z", (Number)src.position.func_177952_p());
        if (src.meta != 0) {
            root.addProperty("meta", (Number)src.meta);
        }
        if (src.nbt != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStream base64os = Base64.getEncoder().wrap(baos);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)src.nbt, (OutputStream)base64os);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (baos != null) {
                root.addProperty("nbt", baos.toString());
            }
            if (!src.writePositionData) {
                root.addProperty("skipPositionData", Boolean.valueOf(true));
            }
        }
        return root;
    }

    public BlockInformation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject jsonRoot = json.getAsJsonObject();
        BlockPos position = new BlockPos(jsonRoot.get("x").getAsInt(), jsonRoot.get("y").getAsInt(), jsonRoot.get("z").getAsInt());
        Block block = Block.func_149684_b((String)jsonRoot.get("block").getAsString());
        int meta = 0;
        if (jsonRoot.has("meta")) {
            meta = jsonRoot.get("meta").getAsInt();
        }
        NBTTagCompound nbt = null;
        if (jsonRoot.has("nbt")) {
            ByteArrayInputStream is = new ByteArrayInputStream(jsonRoot.get("nbt").getAsString().getBytes(StandardCharsets.UTF_8));
            InputStream wrappedIs = Base64.getDecoder().wrap(is);
            try {
                nbt = CompressedStreamTools.func_74796_a((InputStream)wrappedIs);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean writePositionData = !jsonRoot.has("skipPositionData");
        return new BlockInformation(position, block, meta, nbt, writePositionData);
    }
}

