/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.world.WorldSavedDataMachines;

public class MessageMachinePositions
implements IMessage,
IMessageHandler<MessageMachinePositions, IMessage> {
    Map<Integer, BlockPos> machineGrid;
    Map<Integer, EnumMachineSize> machineSizes;

    public MessageMachinePositions() {
    }

    public MessageMachinePositions(Map<Integer, BlockPos> machineGrid, Map<Integer, EnumMachineSize> machineSizes) {
        this.machineGrid = machineGrid;
        this.machineSizes = machineSizes;
    }

    public static MessageMachinePositions initWithWorldSavedData() {
        return new MessageMachinePositions(WorldSavedDataMachines.getInstance().machineGrid, WorldSavedDataMachines.getInstance().machineSizes);
    }

    public static void updateClientMachinePositions() {
        for (EntityPlayerMP p : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            MessageMachinePositions message = MessageMachinePositions.initWithWorldSavedData();
            PackageHandler.instance.sendTo((IMessage)message, p);
        }
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagCompound machineGridTag = tag.func_74775_l("machineGrid");
        NBTTagCompound machineSizesTag = tag.func_74775_l("machineSizes");
        this.machineGrid = new HashMap<Integer, BlockPos>();
        for (String key : machineGridTag.func_150296_c()) {
            this.machineGrid.put(Integer.parseInt(key), NBTUtil.func_186861_c((NBTTagCompound)machineGridTag.func_74775_l(key)));
        }
        this.machineSizes = new HashMap<Integer, EnumMachineSize>();
        for (String key : machineSizesTag.func_150296_c()) {
            this.machineSizes.put(Integer.parseInt(key), EnumMachineSize.getFromMeta(machineSizesTag.func_74762_e(key)));
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound machineGridTag = new NBTTagCompound();
        NBTTagCompound machineSizesTag = new NBTTagCompound();
        for (Map.Entry<Integer, BlockPos> entry : this.machineGrid.entrySet()) {
            machineGridTag.func_74782_a(entry.getKey().toString(), (NBTBase)NBTUtil.func_186859_a((BlockPos)entry.getValue()));
        }
        for (Map.Entry<Integer, Object> entry : this.machineSizes.entrySet()) {
            machineSizesTag.func_74768_a(entry.getKey().toString(), ((EnumMachineSize)((Object)entry.getValue())).getMeta());
        }
        tag.func_74782_a("machineGrid", (NBTBase)machineGridTag);
        tag.func_74782_a("machineSizes", (NBTBase)machineSizesTag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IMessage onMessage(MessageMachinePositions message, MessageContext ctx) {
        WorldSavedDataMachines.setClientMachineGrid(message.machineGrid);
        WorldSavedDataMachines.setClientMachineSizes(message.machineSizes);
        return null;
    }
}

