/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.network;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class MessageMachineContent
implements IMessage {
    protected int machineSize;
    protected int id;
    protected BlockPos roomPos;
    protected DimensionBlockPos machinePos;
    protected String owner;
    protected String customName;
    protected Set<String> playerWhiteList;
    protected boolean locked;

    public MessageMachineContent(int id) {
        TileEntity te;
        this.id = id;
        WorldSavedDataMachines data = WorldSavedDataMachines.getInstance();
        this.roomPos = data.getMachineRoomPosition(id);
        this.machinePos = data.getMachineBlockPosition(id);
        this.machineSize = data.machineSizes.getOrDefault(id, EnumMachineSize.MAXIMUM).getDimension();
        if (this.machinePos != null && (te = DimensionTools.getWorldServerForDimension(this.machinePos.getDimension()).func_175625_s(this.machinePos.getBlockPos())) instanceof TileEntityMachine) {
            TileEntityMachine machine = (TileEntityMachine)te;
            this.owner = machine.getOwnerName();
            this.customName = machine.getCustomName();
            this.playerWhiteList = machine.getWhiteList();
            this.locked = machine.isLocked();
        }
    }

    public MessageMachineContent() {
    }

    public void setMachineSize(int machineSize) {
        this.machineSize = machineSize;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setRoomPos(BlockPos roomPos) {
        this.roomPos = roomPos;
    }

    public void setMachinePos(DimensionBlockPos machinePos) {
        this.machinePos = machinePos;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void fromBytes(ByteBuf buf) {
        boolean hasMachineBlock;
        this.machineSize = buf.readInt();
        this.id = buf.readInt();
        if (buf.readBoolean()) {
            this.roomPos = NBTUtil.func_186861_c((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
        }
        if (hasMachineBlock = buf.readBoolean()) {
            this.machinePos = new DimensionBlockPos(buf);
            this.owner = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.customName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.locked = buf.readBoolean();
        }
        int whiteListSize = buf.readInt();
        this.playerWhiteList = new HashSet<String>();
        for (int i = 0; i < whiteListSize; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.playerWhiteList.add(name);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.machineSize);
        buf.writeInt(this.id);
        if (this.roomPos != null) {
            buf.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)NBTUtil.func_186859_a((BlockPos)this.roomPos));
        } else {
            buf.writeBoolean(false);
        }
        if (this.machinePos != null) {
            buf.writeBoolean(true);
            this.machinePos.writeToByteBuf(buf);
            String owner = this.owner == null ? "" : this.owner;
            String customName = this.customName == null ? "" : this.customName;
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)owner);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)customName);
            buf.writeBoolean(this.locked);
        } else {
            buf.writeBoolean(false);
        }
        if (this.playerWhiteList == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.playerWhiteList.size());
            for (String playerName : this.playerWhiteList) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)playerName);
            }
        }
    }
}

