/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.misc;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RotationTools {
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation arrowImage;

    @SideOnly(value=Side.CLIENT)
    public static void renderArrowOnGround(Vec3d cameraPosition, Vec3d hitPosition, BlockPos drawPosition) {
        EnumFacing facing = RotationTools.getFacingByTriangle(hitPosition);
        TextureRotationList rotList = new TextureRotationList();
        switch (facing) {
            case SOUTH: {
                break;
            }
            case WEST: {
                rotList.rotateFromStart();
                break;
            }
            case NORTH: {
                rotList.rotateFromStart();
                rotList.rotateFromStart();
                break;
            }
            case EAST: {
                rotList.rotateFromStart();
                rotList.rotateFromStart();
                rotList.rotateFromStart();
            }
        }
        if (arrowImage == null) {
            arrowImage = new ResourceLocation("compactmachines3", "textures/particles/blockmarker.png");
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(arrowImage);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-cameraPosition.field_72450_a), (double)(-cameraPosition.field_72448_b), (double)(-cameraPosition.field_72449_c));
        GlStateManager.func_179109_b((float)drawPosition.func_177958_n(), (float)drawPosition.func_177956_o(), (float)drawPosition.func_177952_p());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        rotList.fillBufferBuilder(bufferbuilder, 5.0E-4);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static EnumFacing getFacingByTriangle(Vec3d vec) {
        if (vec.field_72449_c > 0.0) {
            if (vec.field_72450_a < 0.0) {
                if (Math.abs(vec.field_72450_a) < Math.abs(vec.field_72449_c)) {
                    return EnumFacing.SOUTH;
                }
                return EnumFacing.WEST;
            }
            if (Math.abs(vec.field_72450_a) > Math.abs(vec.field_72449_c)) {
                return EnumFacing.EAST;
            }
            return EnumFacing.SOUTH;
        }
        if (vec.field_72450_a < 0.0) {
            if (Math.abs(vec.field_72450_a) < Math.abs(vec.field_72449_c)) {
                return EnumFacing.NORTH;
            }
            return EnumFacing.WEST;
        }
        if (Math.abs(vec.field_72450_a) > Math.abs(vec.field_72449_c)) {
            return EnumFacing.EAST;
        }
        return EnumFacing.NORTH;
    }

    public static class RotatingList<T>
    extends ArrayList<T> {
        public void rotateFromStart() {
            Object firstElement = this.get(0);
            this.remove(0);
            this.add(firstElement);
        }

        public void rotateFromEnd() {
            Object lastElement = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            this.add(0, lastElement);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class TextureRotationList
    extends RotatingList<Tuple<Integer, Integer>> {
        public TextureRotationList() {
            this.add(new Tuple((Object)0, (Object)1));
            this.add(new Tuple((Object)1, (Object)1));
            this.add(new Tuple((Object)1, (Object)0));
            this.add(new Tuple((Object)0, (Object)0));
        }

        public void fillBufferBuilder(BufferBuilder buffer, double yLevel) {
            buffer.func_181662_b(0.0, yLevel, 1.0).func_187315_a((double)((Integer)((Tuple)this.get(0)).func_76341_a()).intValue(), (double)((Integer)((Tuple)this.get(0)).func_76340_b()).intValue()).func_181675_d();
            buffer.func_181662_b(1.0, yLevel, 1.0).func_187315_a((double)((Integer)((Tuple)this.get(1)).func_76341_a()).intValue(), (double)((Integer)((Tuple)this.get(1)).func_76340_b()).intValue()).func_181675_d();
            buffer.func_181662_b(1.0, yLevel, 0.0).func_187315_a((double)((Integer)((Tuple)this.get(2)).func_76341_a()).intValue(), (double)((Integer)((Tuple)this.get(2)).func_76340_b()).intValue()).func_181675_d();
            buffer.func_181662_b(0.0, yLevel, 0.0).func_187315_a((double)((Integer)((Tuple)this.get(3)).func_76341_a()).intValue(), (double)((Integer)((Tuple)this.get(3)).func_76340_b()).intValue()).func_181675_d();
        }
    }
}

