/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dave.compactmachines3.gui.machine.GuiMachineData;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.misc.RotationTools;
import org.dave.compactmachines3.network.MessageMachinePositions;
import org.dave.compactmachines3.network.MessageWorldInfo;
import org.dave.compactmachines3.network.PackageHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.TeleportationTools;

public class PlayerEventHandler {
    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        PackageHandler.instance.sendTo((IMessage)new MessageWorldInfo(DimensionTools.getServerMachineWorld().func_72912_H()), player);
        PackageHandler.instance.sendTo((IMessage)MessageMachinePositions.initWithWorldSavedData(), player);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onGuiClose(GuiOpenEvent event) {
        if (event.getGui() == null) {
            GuiMachineData.canRender = false;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderRotationIndicator(RenderWorldLastEvent event) {
        if (!Minecraft.func_71382_s() || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (!(heldItem.func_77973_b() instanceof ItemBlock) || ((ItemBlock)heldItem.func_77973_b()).func_179223_d() != Blockss.fieldProjector) {
            return;
        }
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace == null || trace.field_72307_f == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        if (trace.field_178784_b != EnumFacing.UP) {
            return;
        }
        Vec3d cameraPosition = new Vec3d(player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks(), player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks(), player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks());
        Vec3d hitPosition = trace.field_72307_f;
        hitPosition = hitPosition.func_178788_d(new Vec3d((Vec3i)trace.func_178782_a()));
        hitPosition = hitPosition.func_178786_a(0.5, 0.5, 0.5);
        BlockPos drawPosition = trace.func_178782_a().func_177984_a();
        RotationTools.renderArrowOnGround(cameraPosition, hitPosition, drawPosition);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.player.field_70170_p.field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return;
        }
        if (event.player.field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        int enteredMachineId = WorldSavedDataMachines.getInstance().getMachineIdFromEntityPos((Entity)event.player);
        int lastId = TeleportationTools.getLastKnownRoomId(event.player, false);
        if (lastId == -1 && !ConfigurationHandler.MachineSettings.allowEnteringWithoutPSD) {
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:nausea"), 200, 5, false, false));
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:wither"), 160, 1, false, false));
            event.player.getEntityData().func_82580_o("compactmachines3-oldDimension");
            event.player.getEntityData().func_82580_o("compactmachines3-oldPosX");
            event.player.getEntityData().func_82580_o("compactmachines3-oldPosY");
            event.player.getEntityData().func_82580_o("compactmachines3-oldPosZ");
            TeleportationTools.teleportPlayerOutOfMachineDimension((EntityPlayerMP)event.player);
            return;
        }
        if (enteredMachineId != -1 && lastId != enteredMachineId && ConfigurationHandler.MachineSettings.allowEnteringWithoutPSD) {
            TeleportationTools.addMachineIdToHistory(enteredMachineId, event.player);
            return;
        }
        if (!ConfigurationHandler.MachineSettings.keepPlayersInside) {
            return;
        }
        EnumMachineSize enumSize = WorldSavedDataMachines.getInstance().machineSizes.get(lastId);
        if (enumSize == null) {
            return;
        }
        if ((event.player.func_184812_l_() || event.player.func_175149_v()) && event.player.func_70003_b(2, "")) {
            return;
        }
        if (lastId != enteredMachineId) {
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:nausea"), 200, 5, false, false));
            event.player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:wither"), 160, 1, false, false));
            TeleportationTools.teleportPlayerOutOfMachine((EntityPlayerMP)event.player);
        }
    }
}

