/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.misc;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.utility.ChunkBlockAccess;
import org.dave.compactmachines3.world.WorldSavedDataMachines;

public class CubeTools {
    public static EnumMachineSize getCubeSize(IBlockAccess world, BlockPos roomPos) {
        for (EnumMachineSize size : EnumMachineSize.values()) {
            BlockPos pos = roomPos.func_177982_a(size.getDimension(), 0, 0);
            if (world.func_180495_p(pos).func_177230_c() != Blockss.wall) continue;
            return size;
        }
        return null;
    }

    public static boolean shouldSideBeRendered(IBlockAccess world, BlockPos blockPos, EnumFacing side) {
        int yOffset = world instanceof ChunkBlockAccess ? 0 : 40;
        int id = WorldSavedDataMachines.getClientMachineIdFromBoxPos(blockPos);
        if (id == -1) {
            return true;
        }
        BlockPos roomPos = WorldSavedDataMachines.getClientMachineGrid().get(id);
        EnumMachineSize sizeEnum = WorldSavedDataMachines.getClientMachineSizes().get(id);
        if (sizeEnum == null) {
            return true;
        }
        int size = sizeEnum.getDimension();
        int x = blockPos.func_177958_n() - roomPos.func_177958_n();
        int y = blockPos.func_177956_o() - yOffset;
        int z = blockPos.func_177952_p() - roomPos.func_177952_p();
        if (x != 0 && x != size && z != 0 && z != size && y > 0 && y < size) {
            return true;
        }
        EnumFacing lookingSide = side.func_176734_d();
        if (lookingSide == EnumFacing.DOWN) {
            return y == 0 && x > 0 && x < size && z > 0 && z < size;
        }
        if (lookingSide == EnumFacing.UP) {
            return y == size && x > 0 && x < size && z > 0 && z < size;
        }
        if (y > 0 && y < size) {
            boolean validX;
            int zEdge;
            int xEdge = lookingSide.func_82601_c() == -1 ? 0 : size;
            int n = zEdge = lookingSide.func_82599_e() == -1 ? 0 : size;
            boolean bl = lookingSide.func_176740_k() == EnumFacing.Axis.X ? x == xEdge : (validX = x > 0 && x < size);
            boolean validZ = lookingSide.func_176740_k() == EnumFacing.Axis.Z ? z == zEdge : z > 0 && z < size;
            return validX && validZ;
        }
        return false;
    }
}

