/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.miniaturization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.dave.compactmachines3.CompactMachines3;
import org.dave.compactmachines3.miniaturization.MultiblockRecipe;
import org.dave.compactmachines3.miniaturization.MultiblockRecipes;

public class MultiblockRecipeSerializer
implements JsonSerializer<MultiblockRecipe>,
JsonDeserializer<MultiblockRecipe> {
    public MultiblockRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String itemId;
        int targetMeta;
        if (!json.isJsonObject()) {
            CompactMachines3.logger.info("Invalid recipe! Not a json object!");
            return null;
        }
        JsonObject jsonRoot = json.getAsJsonObject();
        if (!jsonRoot.has("input-types") || !jsonRoot.has("shape")) {
            CompactMachines3.logger.info("Invalid recipe! Missing section shape and/or input-types!");
            return null;
        }
        if (!jsonRoot.has("name")) {
            CompactMachines3.logger.info("Invalid recipe! Missing recipe name!");
            return null;
        }
        String name = jsonRoot.get("name").getAsString();
        if (MultiblockRecipes.getRecipeByName(name) != null) {
            CompactMachines3.logger.info("Duplicate recipe with name: {}", (Object)name);
            return null;
        }
        if (jsonRoot.has("disabled") && jsonRoot.get("disabled").getAsBoolean()) {
            CompactMachines3.logger.info("Recipe '{}' is disabled via its json file", (Object)name);
            return null;
        }
        ItemStack targetStack = null;
        int targetCount = jsonRoot.has("target-count") ? jsonRoot.get("target-count").getAsInt() : 1;
        int n = targetMeta = jsonRoot.has("target-meta") ? jsonRoot.get("target-meta").getAsInt() : 0;
        if (jsonRoot.has("target-block")) {
            String blockId = jsonRoot.get("target-block").getAsString();
            Block targetBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockId));
            if (targetBlock == null) {
                throw new RuntimeException("Invalid recipe! Unknown target block: \"" + blockId + "\"");
            }
            targetStack = new ItemStack(targetBlock, targetCount, targetMeta);
        } else if (jsonRoot.has("target-item")) {
            String itemId2 = jsonRoot.get("target-item").getAsString();
            Item targetItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId2));
            if (targetItem == null) {
                throw new RuntimeException("Invalid recipe! Unknown target item: \"" + itemId2 + "\"");
            }
            targetStack = new ItemStack(targetItem, targetCount, targetMeta);
        }
        if (targetStack.func_190926_b()) {
            return null;
        }
        if (jsonRoot.has("target-nbt")) {
            String nbtRaw = jsonRoot.get("target-nbt").getAsString();
            try {
                NBTTagCompound targetNBT = JsonToNBT.func_180713_a((String)nbtRaw);
                targetStack.func_77982_d(targetNBT);
            }
            catch (NBTException e) {
                CompactMachines3.logger.warn("Unable to read target NBT tag from miniaturization recipe: {} (exception={})", (Object)nbtRaw, (Object)e);
            }
        }
        Item catalystItem = Items.field_151137_ax;
        if (jsonRoot.has("catalyst") && (catalystItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemId = jsonRoot.get("catalyst").getAsString()))) == null) {
            throw new RuntimeException("Invalid recipe! Unknown target item: \"" + itemId + "\"");
        }
        int catalystMeta = 0;
        if (jsonRoot.has("catalyst-meta")) {
            catalystMeta = jsonRoot.get("catalyst-meta").getAsInt();
        }
        NBTTagCompound catalystNbt = null;
        if (jsonRoot.has("catalyst-nbt")) {
            String nbtRaw = jsonRoot.get("catalyst-nbt").getAsString();
            try {
                catalystNbt = JsonToNBT.func_180713_a((String)nbtRaw);
            }
            catch (NBTException e) {
                CompactMachines3.logger.warn("Unable to read NBT tag from miniaturization recipe: {} (exception={})", (Object)nbtRaw, (Object)e);
            }
        }
        boolean symmetrical = false;
        if (jsonRoot.has("symmetrical")) {
            symmetrical = jsonRoot.get("symmetrical").getAsBoolean();
        }
        int ticks = 100;
        if (jsonRoot.has("duration")) {
            ticks = jsonRoot.get("duration").getAsInt();
        }
        MultiblockRecipe result = new MultiblockRecipe(name, targetStack, catalystItem, catalystMeta, catalystNbt, symmetrical, ticks);
        JsonObject jsonReferenceMap = jsonRoot.get("input-types").getAsJsonObject();
        for (Object entry : jsonReferenceMap.entrySet()) {
            String id;
            Item stackItem;
            JsonObject stackData;
            JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (!data.has("id")) {
                CompactMachines3.logger.error("Missing id for source block");
                return null;
            }
            String blockId = data.get("id").getAsString();
            Block sourceBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockId));
            if (sourceBlock == null) {
                throw new RuntimeException("Invalid recipe! Unknown source block: \"" + blockId + "\"");
            }
            int meta = data.has("meta") ? data.get("meta").getAsInt() : 0;
            IBlockState state = sourceBlock.func_176203_a(meta);
            if (state == null) {
                state = sourceBlock.func_176223_P();
            }
            result.addBlockReference((String)entry.getKey(), state);
            boolean ignoreMeta = false;
            if (data.has("ignore-meta")) {
                ignoreMeta = data.get("ignore-meta").getAsBoolean();
            }
            result.setIgnoreMeta((String)entry.getKey(), ignoreMeta);
            if (!data.has("item") || !(stackData = data.get("item").getAsJsonObject()).has("id") || (stackItem = Item.func_111206_d((String)(id = stackData.get("id").getAsString()))) == null) continue;
            int stackMeta = stackData.has("meta") ? stackData.get("meta").getAsInt() : 0;
            int stackCount = stackData.has("count") ? stackData.get("count").getAsInt() : 1;
            ItemStack stackStack = new ItemStack(stackItem, stackCount, stackMeta);
            if (stackData.has("nbt")) {
                String nbtRaw = stackData.get("nbt").getAsString();
                try {
                    NBTTagCompound stackNbt = JsonToNBT.func_180713_a((String)nbtRaw);
                    stackStack.func_77982_d(stackNbt);
                }
                catch (NBTException e) {
                    CompactMachines3.logger.warn("Unable to read NBT tag from miniaturization recipe: {} (exception={})", (Object)nbtRaw, (Object)e);
                }
            }
            result.setReferenceStack((String)entry.getKey(), stackStack);
        }
        if (jsonRoot.has("input-nbt")) {
            JsonObject jsonVariantMap = jsonRoot.get("input-nbt").getAsJsonObject();
            for (Map.Entry entry : jsonVariantMap.entrySet()) {
                JsonObject data = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (!data.has("nbt")) {
                    CompactMachines3.logger.error("Missing nbt for variant");
                    return null;
                }
                String rawNbtJson = data.get("nbt").getAsString();
                try {
                    NBTTagCompound variantNBT = JsonToNBT.func_180713_a((String)rawNbtJson);
                    result.addBlockVariation((String)entry.getKey(), variantNBT);
                }
                catch (NBTException e) {
                    CompactMachines3.logger.warn("Unable to read NBT tag from miniaturiazation recipe: {} (exception={})", (Object)rawNbtJson, (Object)e);
                    return null;
                }
            }
        }
        JsonArray jsonYPosArray = jsonRoot.get("shape").getAsJsonArray();
        int height = jsonYPosArray.size();
        int width = 0;
        int depth = 0;
        for (JsonElement jsonYElement : jsonYPosArray) {
            JsonArray jsonZPosArray = jsonYElement.getAsJsonArray();
            depth = Math.max(depth, jsonZPosArray.size());
            for (JsonElement jsonZElement : jsonZPosArray) {
                JsonArray jsonXPosArray = jsonZElement.getAsJsonArray();
                width = Math.max(width, jsonXPosArray.size());
            }
        }
        String[][][] positionMap = new String[height][depth][width];
        String[][][] variantMap = new String[height][depth][width];
        int y = 0;
        for (JsonElement jsonYElement : jsonYPosArray) {
            int z = 0;
            for (JsonElement jsonZElement : jsonYElement.getAsJsonArray()) {
                int x = 0;
                for (JsonElement jsonXElement : jsonZElement.getAsJsonArray()) {
                    String ref = jsonXElement.getAsString();
                    if (ref.contains(":")) {
                        positionMap[height - 1 - y][z][x] = ref.substring(0, ref.indexOf(58));
                        variantMap[height - 1 - y][z][x] = ref;
                    } else {
                        positionMap[height - 1 - y][z][x] = ref;
                    }
                    ++x;
                }
                ++z;
            }
            ++y;
        }
        result.setPositionMap(positionMap);
        result.setVariantMap(variantMap);
        return result;
    }

    public JsonElement serialize(MultiblockRecipe src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject root = new JsonObject();
        return root;
    }
}

