/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.network;

import gigaherz.guidebook.network.DisplayMessagePacket;
import gigaherz.guidebook.network.NetworkHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GiveItemPacket
implements IMessage {
    private ItemStack itemStack;
    private int coinsNeeded;

    public GiveItemPacket() {
    }

    public GiveItemPacket(ItemStack itemStack, int coinsNeeded) {
        this.itemStack = itemStack;
        this.coinsNeeded = coinsNeeded;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.coinsNeeded);
    }

    public void fromBytes(ByteBuf buf) {
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.coinsNeeded = ByteBufUtils.readVarShort((ByteBuf)buf);
    }

    private static void deductPlayerCoins(EntityPlayerMP player, int coinsNeeded) {
        ItemStack coinStack = new ItemStack(Item.func_111206_d((String)"thermalfoundation:coin"), 1, 72);
        for (int i = 0; i < player.field_71071_by.field_70462_a.size() && coinsNeeded > 0; ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)coinStack)) continue;
            int inStack = stack.func_190916_E();
            if (inStack <= coinsNeeded) {
                player.field_71071_by.func_70298_a(i, inStack);
                coinsNeeded -= inStack;
                continue;
            }
            player.field_71071_by.func_70298_a(i, coinsNeeded);
            break;
        }
        player.field_71069_bz.func_75142_b();
    }

    private static int getPlayerCoins(EntityPlayerMP player) {
        int count = 0;
        ItemStack coinStack = new ItemStack(Item.func_111206_d((String)"thermalfoundation:coin"), 1, 72);
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)coinStack)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static class Handler
    implements IMessageHandler<GiveItemPacket, IMessage> {
        public IMessage onMessage(GiveItemPacket message, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(() -> {
                EntityPlayerMP serverPlayer = ctx.getServerHandler().field_147369_b;
                int playerCoins = GiveItemPacket.getPlayerCoins(serverPlayer);
                if (playerCoins >= message.coinsNeeded) {
                    if (!serverPlayer.field_71071_by.func_70441_a(message.itemStack)) {
                        NetworkHandler.INSTANCE.sendTo((IMessage)new DisplayMessagePacket("Inventory full. Please make space in your inventory first."), serverPlayer);
                    } else {
                        GiveItemPacket.deductPlayerCoins(serverPlayer, message.coinsNeeded);
                        NetworkHandler.INSTANCE.sendTo((IMessage)new DisplayMessagePacket("Thank you for your purchase!"), serverPlayer);
                    }
                } else {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new DisplayMessagePacket("Not enough coins to make purchase."), serverPlayer);
                }
            });
            return null;
        }
    }
}

