/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.recipe;

import com.google.common.collect.Maps;
import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.guidebook.drawing.VisualElement;
import gigaherz.guidebook.guidebook.elements.ElementImage;
import gigaherz.guidebook.guidebook.elements.ElementStack;
import gigaherz.guidebook.guidebook.recipe.CraftingRecipeProvider;
import gigaherz.guidebook.guidebook.recipe.FurnaceRecipeProvider;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class RecipeProvider {
    public static final Map<ResourceLocation, RecipeProvider> registry = Maps.newHashMap();

    protected static List<ItemStack> copyAndExpand(@Nonnull ItemStack stack) {
        NonNullList stacks = NonNullList.func_191196_a();
        ItemStack base = stack.func_77946_l();
        stacks.add((Object)base);
        if (base.func_77984_f()) {
            base.func_77964_b(0);
        }
        if (base.func_77960_j() == Short.MAX_VALUE && !base.func_77981_g()) {
            base.func_77964_b(0);
        } else if (base.func_77960_j() == Short.MAX_VALUE && base.func_77981_g()) {
            Item item = base.func_77973_b();
            int stackSize = base.func_190916_E();
            NBTTagCompound tag = base.func_77942_o() && base.func_77978_p() != null ? base.func_77978_p().func_74737_b() : null;
            NonNullList processed_items = NonNullList.func_191196_a();
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, subItems);
            for (ItemStack subItem : subItems) {
                subItem = subItem.func_77946_l();
                subItem.func_190920_e(stackSize);
                subItem.func_77982_d(tag);
                processed_items.add((Object)subItem);
            }
            stacks = subItems;
        }
        return stacks;
    }

    @Nullable
    public abstract ProvidedComponents provideRecipeComponents(@Nonnull ItemStack var1, int var2);

    @Nullable
    public abstract ProvidedComponents provideRecipeComponents(@Nonnull ResourceLocation var1);

    static {
        CraftingRecipeProvider crafting = new CraftingRecipeProvider();
        registry.put(GuidebookMod.location("crafting"), crafting);
        registry.put(GuidebookMod.location("shaped"), crafting);
        registry.put(GuidebookMod.location("shapeless"), crafting);
        registry.put(GuidebookMod.location("smelting"), new FurnaceRecipeProvider());
    }

    public static class ProvidedComponents {
        public int height = 0;
        public ElementStack[] recipeComponents;
        public ElementImage background;
        public VisualElement delegate;

        public ProvidedComponents(int h, ElementStack[] rc, ElementImage background, VisualElement ird) {
            this.height = h;
            this.recipeComponents = rc;
            this.background = background;
            this.delegate = ird;
        }
    }
}

