/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.guidebook.client;

import gigaherz.guidebook.GuidebookMod;
import gigaherz.guidebook.client.ModelHandle;
import gigaherz.guidebook.guidebook.client.GuiGuidebook;
import gigaherz.guidebook.guidebook.client.IAnimatedBookBackground;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class AnimatedBookBackground
implements IAnimatedBookBackground {
    private static final float angleSpeed = 0.14285715f;
    private final ModelHandle book00 = ModelHandle.of(GuidebookMod.location("gui/book.obj")).vertexFormat(DefaultVertexFormats.field_181712_l);
    private final ModelHandle book30 = ModelHandle.of(GuidebookMod.location("gui/book30.obj")).vertexFormat(DefaultVertexFormats.field_181712_l);
    private final ModelHandle book60 = ModelHandle.of(GuidebookMod.location("gui/book60.obj")).vertexFormat(DefaultVertexFormats.field_181712_l);
    private final ModelHandle book90 = ModelHandle.of(GuidebookMod.location("gui/book90.obj")).vertexFormat(DefaultVertexFormats.field_181712_l);
    private final GuiGuidebook gui;
    private float angleT = 1.0f;
    private boolean closing = false;

    public AnimatedBookBackground(GuiGuidebook gui) {
        this.gui = gui;
    }

    private static void enableStandardItemLighting() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179085_a((int)0);
        GlStateManager.func_179085_a((int)1);
        GlStateManager.func_179104_a((int)1032, (int)5634);
        GlStateManager.func_179142_g();
        GlStateManager.func_187438_a((int)16384, (int)4611, (FloatBuffer)RenderHelper.func_74521_a((float)-5.0f, (float)-5.0f, (float)1.0f, (float)0.0f));
        GlStateManager.func_187438_a((int)16384, (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f));
        GlStateManager.func_187438_a((int)16384, (int)4608, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16384, (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4611, (FloatBuffer)RenderHelper.func_74521_a((float)5.0f, (float)-6.0f, (float)5.0f, (float)0.0f));
        GlStateManager.func_187438_a((int)16385, (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4608, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_187438_a((int)16385, (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f));
    }

    private static void renderModel(IBakedModel model) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            worldrenderer.func_178981_a(quad.func_178209_a());
        }
        tessellator.func_78381_a();
    }

    private static void renderModelInterpolate(IBakedModel modelA, IBakedModel modelB, float blend) {
        VertexFormat fmt = DefaultVertexFormats.field_181712_l;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, fmt);
        List generalQuadsA = modelA.func_188616_a(null, null, 0L);
        List generalQuadsB = modelB.func_188616_a(null, null, 0L);
        int length = fmt.func_177338_f();
        for (int i = 0; i < generalQuadsA.size(); ++i) {
            BakedQuad quadA = (BakedQuad)generalQuadsA.get(i);
            BakedQuad quadB = (BakedQuad)generalQuadsB.get(i);
            int[] dataA = quadA.func_178209_a();
            int[] dataB = quadB.func_178209_a();
            int[] blended = Arrays.copyOf(dataA, dataA.length);
            for (int j = 0; j < 4; ++j) {
                int o = length / 4 * j;
                for (int k = 0; k < 3; ++k) {
                    float ax = Float.intBitsToFloat(dataA[o + k]);
                    float bx = Float.intBitsToFloat(dataB[o + k]);
                    blended[o + k] = Float.floatToRawIntBits(ax + blend * (bx - ax));
                }
            }
            worldrenderer.func_178981_a(blended);
        }
        tessellator.func_78381_a();
    }

    @Override
    public void startClosing() {
        this.closing = true;
    }

    @Override
    public boolean isFullyOpen() {
        return this.angleT == 0.0f;
    }

    @Override
    public boolean update() {
        if (this.closing) {
            this.angleT += 0.14285715f;
            return this.angleT >= 1.0f;
        }
        if (this.angleT > 0.0f) {
            this.angleT = Math.max(0.0f, this.angleT - 0.14285715f);
        }
        return false;
    }

    @Override
    public void draw(float partialTicks, int bookHeight, float scalingFactor) {
        float blend;
        IBakedModel modelBookB;
        IBakedModel modelBookA;
        float angleX = this.closing ? (this.angleT + partialTicks * 0.14285715f) * 90.0f : (this.angleT - partialTicks * 0.14285715f) * 90.0f;
        if (angleX <= 0.0f) {
            angleX = 0.0f;
            modelBookA = this.book00.get();
            modelBookB = null;
            blend = 0.0f;
        } else if (angleX < 30.0f) {
            modelBookA = this.book00.get();
            modelBookB = this.book30.get();
            blend = angleX / 30.0f;
        } else if (angleX < 60.0f) {
            modelBookA = this.book30.get();
            modelBookB = this.book60.get();
            blend = (angleX - 30.0f) / 30.0f;
        } else if (angleX < 90.0f) {
            modelBookA = this.book60.get();
            modelBookB = this.book90.get();
            blend = (angleX - 60.0f) / 30.0f;
        } else {
            angleX = 90.0f;
            modelBookA = this.book90.get();
            modelBookB = null;
            blend = 0.0f;
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        AnimatedBookBackground.enableStandardItemLighting();
        GlStateManager.func_179137_b((double)((double)this.gui.field_146294_l * 0.5 * (double)(1.0f + angleX / 130.0f)), (double)((double)this.gui.field_146295_m * 0.5 * (double)(1.0f + angleX / 110.0f) + (double)bookHeight * 0.53), (double)50.0);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-130.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(2.16f * scalingFactor), (float)(2.16f * scalingFactor), (float)(2.7f * scalingFactor));
        GlStateManager.func_179114_b((float)(angleX * 1.1f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.getRenderEngine().func_110577_a(TextureMap.field_110575_b);
        if (modelBookB != null) {
            AnimatedBookBackground.renderModelInterpolate(modelBookA, modelBookB, blend);
        } else {
            AnimatedBookBackground.renderModel(modelBookA);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179147_l();
        GlStateManager.func_179097_i();
    }
}

