/*
 * Decompiled with CFR 0.152.
 */
package com.lazerzes.anvils.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GsonHelper {
    public static final Serializer<ResourceLocation> RESOURCE_LOCATION_SERIALIZER = new Serializer<ResourceLocation>(){

        @Override
        public Class<ResourceLocation> getType() {
            return ResourceLocation.class;
        }

        @Override
        public ResourceLocation deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            String domain = json.getAsJsonObject().get("domain").getAsString();
            String path = json.getAsJsonObject().get("path").getAsString();
            return new ResourceLocation(domain, path);
        }

        @Override
        public JsonElement serialize(ResourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("domain", src.func_110624_b());
            object.addProperty("path", src.func_110623_a());
            return object;
        }
    };
    public static final Serializer<NBTTagCompound> NBT_SERIALIZER = new Serializer<NBTTagCompound>(){

        @Override
        public Class<NBTTagCompound> getType() {
            return NBTTagCompound.class;
        }

        @Override
        public NBTTagCompound deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            String nbt = json.getAsJsonObject().get("data").getAsString();
            try {
                return JsonToNBT.func_180713_a((String)nbt);
            }
            catch (NBTException e) {
                e.printStackTrace();
                return new NBTTagCompound();
            }
        }

        @Override
        public JsonElement serialize(NBTTagCompound src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("data", src.toString());
            return object;
        }
    };
    public static final Serializer<ItemStack> ITEM_STACK_SERIALIZER = new Serializer<ItemStack>(){

        @Override
        public Class<ItemStack> getType() {
            return ItemStack.class;
        }

        @Override
        public ItemStack deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation registry = (ResourceLocation)context.deserialize((JsonElement)json.getAsJsonObject().get("registry").getAsJsonObject(), ResourceLocation.class);
            NBTTagCompound nbtTagCompound = (NBTTagCompound)context.deserialize(json.getAsJsonObject().get("nbt"), NBTTagCompound.class);
            int itemCount = json.getAsJsonObject().get("count").getAsInt();
            int itemMeta = json.getAsJsonObject().get("meta").getAsInt();
            ItemStack stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(registry), itemCount, itemMeta);
            stack.func_77982_d(nbtTagCompound);
            return stack;
        }

        @Override
        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.add("registry", context.serialize((Object)src.func_77973_b().getRegistryName()));
            obj.add("nbt", context.serialize((Object)src.func_77978_p()));
            obj.add("count", context.serialize((Object)src.func_190916_E()));
            obj.add("meta", context.serialize((Object)src.func_77960_j()));
            return obj;
        }
    };
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(RESOURCE_LOCATION_SERIALIZER.getType(), RESOURCE_LOCATION_SERIALIZER).registerTypeAdapter(NBT_SERIALIZER.getType(), NBT_SERIALIZER).registerTypeAdapter(ITEM_STACK_SERIALIZER.getType(), ITEM_STACK_SERIALIZER).create();

    public static abstract class Serializer<T>
    implements JsonDeserializer<T>,
    JsonSerializer<T> {
        public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            return (T)context.deserialize(jsonElement, this.getType());
        }

        public JsonElement serialize(T t, Type type, JsonSerializationContext context) {
            return context.serialize(t);
        }

        public abstract Class<T> getType();
    }
}

