/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import openblocks.Config;
import openblocks.common.tileentity.TileEntityBlockManipulator;
import openmods.fakeplayer.BreakBlockAction;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.utils.InventoryUtils;
import openmods.utils.ItemUtils;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityBlockBreaker
extends TileEntityBlockManipulator {
    @IncludeInterface(value=IInventory.class)
    private final GenericInventory inventory = this.registerInventoryCallback(new GenericInventory("blockbreaker", true, 1){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return false;
        }
    });

    @Override
    protected boolean canWork(IBlockState targetState, BlockPos target, EnumFacing direction) {
        Block block = targetState.func_177230_c();
        return !block.isAir(targetState, (IBlockAccess)this.field_145850_b, target) && block != Blocks.field_150357_h && targetState.func_185887_b(this.field_145850_b, target) > -1.0f;
    }

    @Override
    protected void doWork(IBlockState targetState, BlockPos target, EnumFacing direction) {
        List drops = (List)FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, (FakePlayerPool.PlayerUserReturning)new BreakBlockAction(this.field_145850_b, target).findEffectiveTool());
        if (drops.isEmpty()) {
            return;
        }
        EnumFacing dropSide = direction.func_176734_d();
        IItemHandler targetInventory = InventoryUtils.tryGetHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dropSide), (EnumFacing)direction);
        if (targetInventory == null) {
            return;
        }
        for (EntityItem drop : drops) {
            ItemStack stack = drop.func_92059_d();
            ItemStack leftovers = ItemHandlerHelper.insertItem((IItemHandler)targetInventory, (ItemStack)stack, (boolean)false);
            ItemUtils.setEntityItemStack((EntityItem)drop, (ItemStack)leftovers);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected int getActionLimit() {
        return Config.blockBreakerActionLimit;
    }
}

