/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openblocks.client.renderer.block.canvas.BakedModelCanvas;
import openmods.model.ModelUpdater;
import openmods.utils.CollectionUtils;

public class ModelCanvas
implements IModel {
    public static final IModel INSTANCE = new ModelCanvas(Optional.empty(), (Set<BlockRenderLayer>)ImmutableSet.of());
    private final Optional<ResourceLocation> baseModel;
    private final Set<BlockRenderLayer> baseModelRenderLayers;

    private ModelCanvas(Optional<ResourceLocation> baseModel, Set<BlockRenderLayer> baseModelRenderLayers) {
        this.baseModel = baseModel;
        this.baseModelRenderLayers = ImmutableSet.copyOf(baseModelRenderLayers);
    }

    public Collection<ResourceLocation> getDependencies() {
        return CollectionUtils.asSet(this.baseModel);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelState)state);
        IModel base = this.baseModel.isPresent() ? ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.baseModel.get(), (String)("Couldn't load canvas base: " + this.baseModel.get())) : ModelLoaderRegistry.getMissingModel();
        IBakedModel bakedBaseModel = base.bake(state, format, bakedTextureGetter);
        return new BakedModelCanvas(bakedBaseModel, this.baseModelRenderLayers, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms, bakedTextureGetter, format);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater(customData);
        Optional base = updater.get("base", ModelUpdater.MODEL_LOCATION, this.baseModel);
        Set layers = updater.get("baseLayers", ModelUpdater.enumConverter(BlockRenderLayer.class), this.baseModelRenderLayers);
        return updater.hasChanged() ? new ModelCanvas(base, layers) : this;
    }
}

