/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import mcjty.rftools.craftinggrid.IItemKey;
import mcjty.rftools.craftinggrid.IItemSource;
import mcjty.rftools.craftinggrid.PacketCraftTestResultToClient;
import mcjty.rftools.craftinggrid.PacketGridToClient;
import mcjty.rftools.items.storage.StorageModuleItem;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import org.thetorg.blocks.BigBinItemBlock;

public class StorageCraftingTools {
    @Nonnull
    private static int[] tryRecipe(EntityPlayer player, CraftingRecipe craftingRecipe, int n, IItemSource itemSource, boolean strictDamage) {
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        InventoryCrafting inventory = craftingRecipe.getInventory();
        int[] missingCount = new int[10];
        TIntHashSet[] hashSets = new TIntHashSet[9];
        for (int i = 0; i < 10; ++i) {
            if (i < 9) {
                ItemStack stack = inventory.func_70301_a(i);
                if (!stack.func_190926_b()) {
                    missingCount[i] = stack.func_190916_E() * n;
                    hashSets[i] = new TIntHashSet(OreDictionary.getOreIDs((ItemStack)stack));
                } else {
                    missingCount[i] = 0;
                }
                workInventory.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            missingCount[i] = 0;
        }
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            int size = input.func_190916_E();
            if (input.func_190926_b()) continue;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack;
                if (missingCount[i] <= 0 || !StorageCraftingTools.match(stack = inventory.func_70301_a(i), hashSets[i], input, strictDamage)) continue;
                if (size > missingCount[i]) {
                    size -= missingCount[i];
                    missingCount[i] = 0;
                } else {
                    int n2 = i;
                    missingCount[n2] = missingCount[n2] - size;
                    size = 0;
                }
                workInventory.func_70299_a(i, input.func_77946_l());
            }
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        missingCount[9] = !recipe.func_77569_a(workInventory, player.func_130014_f_()) ? 1 : 0;
        if (missingCount[9] == 0) {
            for (int i = 0; i < 9; ++i) {
                if (missingCount[i] <= 0) continue;
                missingCount[9] = 1;
                break;
            }
        }
        return missingCount;
    }

    private static List<ItemStack> testAndConsumeCraftingItems(EntityPlayer player, CraftingRecipe craftingRecipe, IItemSource itemSource, boolean strictDamage) {
        ItemStack stack;
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        ArrayList<Pair<IItemKey, ItemStack>> undo = new ArrayList<Pair<IItemKey, ItemStack>>();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        InventoryCrafting inventory = craftingRecipe.getInventory();
        NBTTagCompound sourceItemTag = new NBTTagCompound();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stack = inventory.func_70301_a(i);
            if (!stack.func_190926_b()) {
                int count = stack.func_190916_E();
                if ((count = StorageCraftingTools.findMatchingItems(workInventory, undo, i, stack, count, itemSource, strictDamage)) > 0) {
                    StorageCraftingTools.undo(player, itemSource, undo);
                    return Collections.emptyList();
                }
                if (!(stack.func_77973_b() instanceof BigBinItemBlock) && !(stack.func_77973_b() instanceof StorageModuleItem)) continue;
                sourceItemTag = workInventory.func_70301_a(i).func_77978_p().func_74737_b();
                continue;
            }
            workInventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (!recipe.func_77569_a(workInventory, player.func_130014_f_())) {
            result.clear();
            StorageCraftingTools.undo(player, itemSource, undo);
            return result;
        }
        stack = recipe.func_77572_b(workInventory);
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof BigBinItemBlock && stack.func_77942_o()) {
                String tier = stack.func_77978_p().func_74779_i("Tier");
                sourceItemTag.func_74778_a("Tier", tier);
                stack.func_77982_d(sourceItemTag);
            } else if (stack.func_77973_b() instanceof StorageModuleItem) {
                stack.func_77982_d(sourceItemTag);
            }
            result.add(stack);
            NonNullList remaining = recipe.func_179532_b(workInventory);
            for (ItemStack s : remaining) {
                if (s.func_190926_b()) continue;
                result.add(s);
            }
        } else {
            result.clear();
            StorageCraftingTools.undo(player, itemSource, undo);
        }
        return result;
    }

    private static boolean match(@Nonnull ItemStack target, @Nonnull TIntHashSet targetIDs, @Nonnull ItemStack input, boolean strictDamage) {
        int[] inputIDs;
        if (strictDamage) {
            return target.func_77973_b() == input.func_77973_b() && target.func_82833_r().equals(input.func_82833_r()) && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
        }
        if (target.func_77973_b() == input.func_77973_b()) {
            return true;
        }
        if (targetIDs.isEmpty()) {
            return false;
        }
        for (int id : inputIDs = OreDictionary.getOreIDs((ItemStack)input)) {
            if (!targetIDs.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static int findMatchingItems(InventoryCrafting workInventory, List<Pair<IItemKey, ItemStack>> undo, int i, @Nonnull ItemStack stack, int count, IItemSource itemSource, boolean strictDamage) {
        TIntHashSet stackIDs = new TIntHashSet(OreDictionary.getOreIDs((ItemStack)stack));
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            if (!input.func_190926_b() && StorageCraftingTools.match(stack, stackIDs, input, strictDamage)) {
                int got;
                int toExtract = Math.min(input.func_190916_E(), count);
                IItemKey key = (IItemKey)pair.getKey();
                ItemStack extracted = itemSource.decrStackSize(key, toExtract);
                int n = got = extracted.func_190926_b() ? 0 : extracted.func_190916_E();
                if (got > 0) {
                    workInventory.func_70299_a(i, extracted.func_77946_l());
                    undo.add((Pair<IItemKey, ItemStack>)Pair.of((Object)key, (Object)extracted));
                    count -= got;
                }
            }
            if (count != 0) continue;
            break;
        }
        return count;
    }

    private static void undo(EntityPlayer player, IItemSource itemSource, List<Pair<IItemKey, ItemStack>> undo) {
        for (Pair<IItemKey, ItemStack> pair : undo) {
            int amountLeft;
            ItemStack stack = (ItemStack)pair.getValue();
            if (itemSource.insertStack((IItemKey)pair.getKey(), stack) || (amountLeft = itemSource.insertStackAnySlot((IItemKey)pair.getKey(), stack)) <= 0) continue;
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(amountLeft);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)copy);
        }
        player.field_71070_bA.func_75142_b();
    }

    public static void craftItems(EntityPlayer player, int n, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (recipe == null) {
            return;
        }
        ItemStack recipeResult = recipe.func_77571_b();
        if (!recipeResult.func_190926_b() && recipeResult.func_190916_E() > 0) {
            if (n == -1) {
                n = recipeResult.func_77976_d();
            }
            int remainder = n % recipeResult.func_190916_E();
            n /= recipeResult.func_190916_E();
            if (remainder != 0) {
                ++n;
            }
            if (n * recipeResult.func_190916_E() > recipeResult.func_77976_d()) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                List<ItemStack> result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, true);
                if (result.isEmpty() && (result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, false)).isEmpty()) {
                    return;
                }
                for (ItemStack stack : result) {
                    if (player.field_71071_by.func_70441_a(stack)) continue;
                    player.func_70099_a(stack, 1.05f);
                }
            }
        }
    }

    @Nonnull
    public static int[] testCraftItems(EntityPlayer player, int n, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (recipe == null) {
            return new int[0];
        }
        ItemStack recipeResult = recipe.func_77571_b();
        if (!recipeResult.func_190926_b() && recipeResult.func_190916_E() > 0) {
            if (n == -1) {
                n = recipeResult.func_77976_d();
            }
            int remainder = n % recipeResult.func_190916_E();
            n /= recipeResult.func_190916_E();
            if (remainder != 0) {
                ++n;
            }
            if (n * recipeResult.func_190916_E() > recipeResult.func_77976_d()) {
                --n;
            }
            int[] result = StorageCraftingTools.tryRecipe(player, craftingRecipe, n, itemSource, true);
            for (int i = 0; i < 10; ++i) {
                if (result[i] <= 0) continue;
                int[] result2 = StorageCraftingTools.tryRecipe(player, craftingRecipe, n, itemSource, false);
                if (result2[9] == 0) {
                    return result2;
                }
                return result;
            }
            return result;
        }
        return new int[0];
    }

    public static void craftFromGrid(EntityPlayer player, int count, boolean test, BlockPos pos) {
        player.func_71029_a(StatList.field_188062_ab);
        int[] testResult = new int[]{};
        if (pos == null) {
            ItemStack mainhand = player.func_184614_ca();
            if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
                if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                    ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                    testResult = storageItemContainer.getCraftingGridProvider().craft(player, count, test);
                } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                    RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                    testResult = storageItemContainer.getCraftingGridProvider().craft(player, count, test);
                } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                    StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                    testResult = storageItemContainer.getStorageScannerTileEntity().craft(player, count, test);
                }
            }
        } else {
            TileEntity te = player.func_130014_f_().func_175625_s(pos);
            if (te instanceof CraftingGridProvider) {
                testResult = ((CraftingGridProvider)te).craft(player, count, test);
            }
        }
        if (testResult.length > 0) {
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketCraftTestResultToClient(testResult), (EntityPlayerMP)player);
        }
    }

    public static void requestGridSync(EntityPlayer player, BlockPos pos) {
        World world = player.func_130014_f_();
        CraftingGridProvider provider = null;
        if (pos == null) {
            ItemStack mainhand = player.func_184614_ca();
            if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
                if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                    ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                    provider = storageItemContainer.getCraftingGridProvider();
                } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                    RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                    provider = storageItemContainer.getCraftingGridProvider();
                } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                    StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                    provider = storageItemContainer.getStorageScannerTileEntity();
                }
            }
        } else {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof CraftingGridProvider) {
                provider = (CraftingGridProvider)te;
            }
        }
        if (provider != null) {
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketGridToClient(pos, provider.getCraftingGrid()), (EntityPlayerMP)player);
        }
    }
}

