/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.blocks.security.GuiSecurityManager;
import mcjty.rftools.blocks.security.SecurityChannels;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSecurityInfoReady
implements IMessage {
    private SecurityChannels.SecurityChannel channel;

    public void fromBytes(ByteBuf buf) {
        this.channel = new SecurityChannels.SecurityChannel();
        this.channel.setName(NetworkTools.readString((ByteBuf)buf));
        this.channel.setWhitelist(buf.readBoolean());
        int size = buf.readInt();
        this.channel.clearPlayers();
        for (int i = 0; i < size; ++i) {
            this.channel.addPlayer(NetworkTools.readString((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.channel.getName());
        buf.writeBoolean(this.channel.isWhitelist());
        List<String> players = this.channel.getPlayers();
        buf.writeInt(players.size());
        for (String player : players) {
            NetworkTools.writeString((ByteBuf)buf, (String)player);
        }
    }

    public PacketSecurityInfoReady() {
    }

    public PacketSecurityInfoReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketSecurityInfoReady(SecurityChannels.SecurityChannel channel) {
        this.channel = channel;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            GuiSecurityManager.channelFromServer = this.channel;
        });
        ctx.setPacketHandled(true);
    }
}

