/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import cofh.core.util.helpers.ItemHelper;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidIngredientFactory
implements IIngredientFactory {
    @Nonnull
    public Ingredient parse(JsonContext context, JsonObject json) {
        String fluidName = "water";
        return new FluidIngredient("sulphuricacid");
    }

    public static class FluidIngredient
    extends Ingredient {
        private FluidStack fluid;

        public FluidIngredient(String fluidName) {
            super(new ItemStack[]{FluidUtil.getFilledBucket((FluidStack)new FluidStack(FluidRegistry.getFluid((String)fluidName), 1000))});
            this.fluid = FluidRegistry.getFluidStack((String)fluidName, (int)1000);
        }

        public boolean apply(@Nullable ItemStack input) {
            IFluidHandlerItem handler;
            if (input == null || input.func_190926_b()) {
                return false;
            }
            IFluidHandlerItem iFluidHandlerItem = handler = input.func_190916_E() > 1 ? FluidUtil.getFluidHandler((ItemStack)ItemHelper.cloneStack(input, 1)) : FluidUtil.getFluidHandler((ItemStack)input);
            if (handler == null) {
                return false;
            }
            return this.fluid.isFluidStackIdentical(handler.drain(1000, false));
        }

        public boolean isSimple() {
            return false;
        }
    }
}

