/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render.font;

import cofh.core.proxy.ProxyClient;
import cofh.core.render.FontRendererCore;
import cofh.core.render.font.ICustomCharRenderer;
import cofh.core.util.helpers.SecurityHelper;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderPlayerFace
implements ICustomCharRenderer {
    static GameProfile profile;
    private static final HashMap<GameProfile, GameProfile> textureCache;
    public static final char CHAR_FACE = '\u0378';

    public static char init(FontRendererCore render) {
        RenderPlayerFace renderPlayerFace = new RenderPlayerFace();
        render.renderOverrides.put('\u0378', (Object)renderPlayerFace);
        return '\u0378';
    }

    public static GameProfile loadTextures(GameProfile profile) {
        if (profile == null) {
            return null;
        }
        if (profile.isComplete()) {
            Property property;
            GameProfile newProfile = textureCache.get(profile);
            if (newProfile != null) {
                return newProfile;
            }
            if (!profile.getProperties().containsKey((Object)"textures") && (property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null)) == null) {
                profile = Minecraft.func_71410_x().func_152347_ac().fillProfileProperties(profile, true);
                textureCache.put(profile, profile);
            }
        }
        return profile;
    }

    public static FontRendererCore loadProfile(ItemStack item) {
        GameProfile profile = SecurityHelper.getOwner(item);
        if (profile == SecurityHelper.UNKNOWN_GAME_PROFILE) {
            profile = null;
        }
        return RenderPlayerFace.setProfile(profile);
    }

    private static FontRendererCore setProfile(GameProfile gameProfile) {
        profile = gameProfile != null ? RenderPlayerFace.loadTextures(gameProfile) : null;
        return ProxyClient.fontRenderer;
    }

    @Override
    public float renderChar(char letter, boolean italicFlag, float x, float y, FontRendererCore fontRenderer) {
        Minecraft minecraft;
        Map map;
        ResourceLocation resourcelocation = new ResourceLocation("textures/entity/steve.png");
        if (profile != null && (map = (minecraft = Minecraft.func_71410_x()).func_152342_ad().func_152788_a(profile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        fontRenderer.bindTexture(resourcelocation);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float italicOffset = italicFlag ? 1.0f : 0.0f;
        float innerFace = 0.0f;
        GL11.glBegin((int)5);
        float width = 64.0f;
        float height = 64.0f;
        GL11.glTexCoord2f((float)(8.0f / width), (float)(8.0f / height));
        GL11.glVertex3f((float)(x + innerFace + italicOffset), (float)(y + innerFace), (float)0.0f);
        GL11.glTexCoord2f((float)(8.0f / width), (float)(16.0f / height));
        GL11.glVertex3f((float)(x + innerFace - italicOffset), (float)(y + 7.99f - innerFace), (float)0.0f);
        GL11.glTexCoord2f((float)(16.0f / width), (float)(8.0f / height));
        GL11.glVertex3f((float)(x + 7.99f - innerFace + italicOffset), (float)(y + innerFace), (float)0.0f);
        GL11.glTexCoord2f((float)(16.0f / width), (float)(16.0f / height));
        GL11.glVertex3f((float)(x + 7.99f - innerFace - italicOffset), (float)(y + 7.99f - innerFace), (float)0.0f);
        GL11.glEnd();
        float hatZ = 0.01f;
        float outerFace = 0.44444445f;
        GL11.glBegin((int)5);
        GL11.glTexCoord2f((float)(40.0f / width), (float)(8.0f / height));
        GL11.glVertex3f((float)(x + italicOffset - outerFace), (float)(y - outerFace), (float)hatZ);
        GL11.glTexCoord2f((float)(40.0f / width), (float)(16.0f / height));
        GL11.glVertex3f((float)(x - italicOffset - outerFace), (float)(y + 7.99f + outerFace), (float)hatZ);
        GL11.glTexCoord2f((float)(48.0f / width), (float)(8.0f / height));
        GL11.glVertex3f((float)(x + 7.99f + italicOffset + outerFace), (float)(y - outerFace), (float)hatZ);
        GL11.glTexCoord2f((float)(48.0f / width), (float)(16.0f / height));
        GL11.glVertex3f((float)(x + 7.99f - italicOffset + outerFace), (float)(y + 7.99f + outerFace), (float)hatZ);
        GL11.glEnd();
        fontRenderer.resetColor();
        return 8.02f;
    }

    @Override
    public int getCharWidth(char letter, FontRendererCore fontRenderer) {
        return 8;
    }

    static {
        textureCache = new HashMap();
    }
}

