/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.client;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.GuiTextList;
import cofh.core.gui.container.ContainerFriendsList;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketSocial;
import cofh.core.util.RegistrySocial;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiFriendList
extends GuiContainerCore {
    static final String TEXTURE_PATH = "cofh:textures/gui/friend_list.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("cofh:textures/gui/friend_list.png");
    static final int TB_HEIGHT = 12;
    GuiTextField tbName;
    GuiTextList taOnlineList;
    public GuiTextList taFriendList;
    ElementButton flUp;
    ElementButton flDown;
    ElementButton olUp;
    ElementButton olDown;
    ElementButton addName;
    ElementButton removeName;
    String tempName;
    int tbNameX = 0;
    int tbNameY = 0;
    int taX = 0;
    int taY = 0;
    int taflX = 0;
    int taflY = 0;

    public GuiFriendList(InventoryPlayer inventory) {
        super(new ContainerFriendsList(inventory), TEXTURE);
        this.name = "gui.cofh.friendList";
        this.drawInventory = false;
        this.field_147000_g = 188;
        this.generateInfo("tab.cofh.friendList");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab(new TabInfo((GuiContainerCore)this, this.myInfo));
        this.tbNameX = this.field_147003_i + 8 + 4;
        this.tbNameY = this.field_147009_r + 15 + 2;
        this.taX = this.field_147003_i + 8;
        this.taY = this.field_147009_r + 32;
        this.taflX = this.field_147003_i + 8;
        this.taflY = this.field_147009_r + 80;
        String temp = "";
        if (this.tbName != null) {
            temp = this.tbName.func_146179_b();
        }
        this.tbName = new GuiTextField(0, this.field_146289_q, this.tbNameX, this.tbNameY, 128, 12);
        this.tbName.func_146203_f(20);
        this.tbName.func_146180_a(temp);
        this.tbName.func_146185_a(false);
        this.taFriendList = new GuiTextList(this.field_146289_q, this.taflX, this.taflY, 128, 10);
        this.taFriendList.textLines = RegistrySocial.clientPlayerFriends;
        this.taFriendList.drawBackground = false;
        this.taFriendList.drawBorder = false;
        this.taOnlineList = new GuiTextList(this.field_146289_q, this.taX, this.taY, 128, 4);
        this.taOnlineList.textLines = this.getOnlineNames();
        this.taOnlineList.drawBackground = false;
        this.taOnlineList.drawBorder = false;
        this.addName = new ElementButton(this, 139, 13, "SetName", 208, 128, 208, 144, 208, 160, 16, 16, TEXTURE_PATH);
        this.removeName = new ElementButton(this, 155, 13, "RemoveName", 224, 128, 224, 144, 224, 160, 16, 16, TEXTURE_PATH);
        this.olUp = new ElementButton(this, 147, 33, "OnlineUp", 208, 64, 208, 80, 208, 96, 16, 16, TEXTURE_PATH);
        this.olDown = new ElementButton(this, 147, 58, "OnlineDown", 224, 64, 224, 80, 224, 96, 16, 16, TEXTURE_PATH);
        this.flUp = new ElementButton(this, 147, 87, "FriendsUp", 208, 64, 208, 80, 208, 96, 16, 16, TEXTURE_PATH);
        this.flDown = new ElementButton(this, 147, 159, "FriendsDown", 224, 64, 224, 80, 224, 96, 16, 16, TEXTURE_PATH);
        this.addElement(this.addName);
        this.addElement(this.removeName);
        this.addElement(this.olUp);
        this.addElement(this.olDown);
        this.addElement(this.flUp);
        this.addElement(this.flDown);
        this.updateButtons();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void handleElementButtonClick(String buttonName, int mouseButton) {
        switch (buttonName) {
            case "SetName": {
                PacketHandler.sendToServer(new PacketSocial().addByte(PacketSocial.PacketTypes.ADD_FRIEND.ordinal()).addString(this.tbName.func_146179_b()));
                break;
            }
            case "RemoveName": {
                PacketHandler.sendToServer(new PacketSocial().addByte(PacketSocial.PacketTypes.REMOVE_FRIEND.ordinal()).addString(this.tbName.func_146179_b()));
                break;
            }
            case "OnlineUp": {
                this.taOnlineList.scrollDown();
                break;
            }
            case "OnlineDown": {
                this.taOnlineList.scrollUp();
                break;
            }
            case "FriendsUp": {
                this.taFriendList.scrollDown();
                break;
            }
            case "FriendsDown": {
                this.taFriendList.scrollUp();
            }
        }
    }

    @Override
    public void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.tbName.func_146194_f();
        this.taOnlineList.drawText();
        this.taFriendList.drawText();
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public void func_73876_c() {
        this.tbName.func_146178_a();
    }

    @Override
    protected void func_73869_a(char i, int j) {
        this.tbName.func_146201_a(i, j);
        if (j == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (this.tbName.func_146206_l() && j == 28) {
            GuiFriendList.playClickSound(0.7f);
        }
        this.updateButtons();
    }

    @Override
    protected void func_73864_a(int mX, int mY, int mButton) throws IOException {
        int textAreaX = this.taFriendList.xPos - this.field_147003_i;
        int textAreaY = this.taFriendList.yPos - this.field_147009_r;
        int onlineX = this.taOnlineList.xPos - this.field_147003_i;
        int onlineY = this.taOnlineList.yPos - this.field_147009_r;
        if (onlineX <= this.mouseX && this.mouseX < onlineX + this.taOnlineList.width && this.mouseY >= onlineY && this.mouseY < onlineY + this.taOnlineList.height) {
            if (!this.taOnlineList.mouseClicked(this.mouseX, this.mouseY, mButton, onlineY).equalsIgnoreCase(this.tbName.func_146179_b())) {
                this.tbName.func_146180_a(this.taOnlineList.mouseClicked(this.mouseX, this.mouseY, mButton, onlineY));
            }
        } else if (textAreaX <= this.mouseX && this.mouseX < textAreaX + this.taFriendList.width && this.mouseY >= textAreaY && this.mouseY < textAreaY + this.taFriendList.height) {
            if (!this.taFriendList.mouseClicked(this.mouseX, this.mouseY, mButton, textAreaY).equalsIgnoreCase(this.tbName.func_146179_b())) {
                this.tbName.func_146180_a(this.taFriendList.mouseClicked(this.mouseX, this.mouseY, mButton, textAreaY));
            }
        } else if (this.tbNameX - this.field_147003_i <= this.mouseX && this.mouseX < this.tbNameX - this.field_147003_i + this.tbName.func_146200_o() && this.mouseY >= this.tbNameY - this.field_147009_r && this.mouseY < this.tbNameY - this.field_147009_r + 12) {
            this.tbName.func_146195_b(true);
        } else {
            super.func_73864_a(mX, mY, mButton);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.canScrollUpFriend()) {
            this.flUp.setActive();
        } else {
            this.flUp.setDisabled();
        }
        if (this.canScrollDownFriend()) {
            this.flDown.setActive();
        } else {
            this.flDown.setDisabled();
        }
        if (this.canScrollUpOnline()) {
            this.olUp.setActive();
        } else {
            this.olUp.setDisabled();
        }
        if (this.canScrollDownOnline()) {
            this.olDown.setActive();
        } else {
            this.olDown.setDisabled();
        }
        if (RegistrySocial.clientPlayerFriends.contains(this.tbName.func_146179_b().toLowerCase(Locale.US))) {
            this.addName.setDisabled();
            this.removeName.setActive();
        } else {
            this.addName.setActive();
            this.removeName.setDisabled();
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int textAreaX = this.taFriendList.xPos - this.field_147003_i;
        int textAreaY = this.taFriendList.yPos - this.field_147009_r;
        int onlineX = this.taOnlineList.xPos - this.field_147003_i;
        int onlineY = this.taOnlineList.yPos - this.field_147009_r;
        if (textAreaX <= this.mouseX && this.mouseX < textAreaX + this.taFriendList.width && this.mouseY >= textAreaY && this.mouseY < textAreaY + this.taFriendList.height) {
            int wheelDir = Mouse.getEventDWheel();
            if (wheelDir < 0) {
                this.taFriendList.scrollUp();
            }
            if (wheelDir > 0) {
                this.taFriendList.scrollDown();
            }
        } else if (onlineX <= this.mouseX && this.mouseX < onlineX + this.taOnlineList.width && this.mouseY >= onlineY && this.mouseY < onlineY + this.taOnlineList.height) {
            int wheelDir = Mouse.getEventDWheel();
            if (wheelDir < 0) {
                this.taOnlineList.scrollUp();
            }
            if (wheelDir > 0) {
                this.taOnlineList.scrollDown();
            }
        }
        this.updateButtons();
    }

    private boolean canScrollUpOnline() {
        return this.taOnlineList.startLine != 0;
    }

    private boolean canScrollDownOnline() {
        return this.taOnlineList.textLines.size() > this.taOnlineList.displayLines && this.taOnlineList.startLine < this.taOnlineList.textLines.size() - this.taOnlineList.displayLines;
    }

    private boolean canScrollUpFriend() {
        return this.taFriendList.startLine != 0;
    }

    private boolean canScrollDownFriend() {
        return this.taFriendList.textLines.size() > this.taFriendList.displayLines && this.taFriendList.startLine < this.taFriendList.textLines.size() - this.taFriendList.displayLines;
    }

    public List<String> getOnlineNames() {
        LinkedList<String> online = new LinkedList<String>();
        for (NetworkPlayerInfo playerInfo : Minecraft.func_71410_x().field_71439_g.field_71174_a.func_175106_d()) {
            online.add(playerInfo.func_178845_a().getName());
        }
        return online;
    }
}

