/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers;

import com.buuz135.industrial.api.IndustrialForegoingHelper;
import com.buuz135.industrial.api.extractor.ExtractorEntry;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.FluidDictionaryEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.api.recipe.SludgeEntry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.utils.apihandlers.crafttweaker.CTAction;
import com.google.common.collect.LinkedListMultimap;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeHandlers {
    public static final LinkedListMultimap<CTAction, BioReactorEntry> BIOREACTOR_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, LaserDrillEntry> LASER_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, SludgeEntry> SLUDGE_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, ProteinReactorEntry> PROTEIN_REACTOR_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, FluidDictionaryEntry> FLUID_DICTIONARY_ENTRIES = LinkedListMultimap.create();
    public static final LinkedListMultimap<CTAction, ExtractorEntry> EXTRACTOR_ENTRIES = LinkedListMultimap.create();

    public static void loadBioReactorEntries() {
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151014_N)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151080_bb)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151081_bc)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_185163_cU)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151172_bF)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151174_bG)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Items.field_151075_bm)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((Block)Blocks.field_150338_P)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((Block)Blocks.field_150337_Q)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack(Blocks.field_185766_cS)));
        IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry(new ItemStack((Block)Blocks.field_150436_aH)));
        RecipeHandlers.getRealOredictedItems("dye").forEach(stack -> IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry((ItemStack)stack)));
        RecipeHandlers.getRealOredictedItems("treeSapling").stream().filter(stack -> !stack.func_77973_b().getRegistryName().func_110623_a().equals("forestry")).forEach(stack -> IndustrialForegoingHelper.addBioReactorEntry(new BioReactorEntry((ItemStack)stack)));
    }

    public static void executeCraftweakerActions() {
        BIOREACTOR_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addBioReactorEntry(entry);
            } else {
                IndustrialForegoingHelper.removeBioReactorEntry(entry.getStack());
            }
        });
        LASER_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addLaserDrillEntry(entry);
            } else {
                IndustrialForegoingHelper.removeLaserDrillEntry(entry.getStack());
            }
        });
        SLUDGE_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addSludgeRefinerEntry(entry);
            } else {
                IndustrialForegoingHelper.removeSludgeRefinerEntry(entry.getStack());
            }
        });
        PROTEIN_REACTOR_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addProteinReactorEntry(entry);
            } else {
                IndustrialForegoingHelper.removeProteinReactorEntry(entry.getStack());
            }
        });
        FLUID_DICTIONARY_ENTRIES.forEach((ctAction, entry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addFluidDictionaryEntry(entry);
            } else {
                IndustrialForegoingHelper.removeFluidDictionaryEntry(entry);
            }
        });
        EXTRACTOR_ENTRIES.forEach((ctAction, extractorEntry) -> {
            if (ctAction == CTAction.ADD) {
                IndustrialForegoingHelper.addWoodToLatex(extractorEntry);
            } else {
                IndustrialForegoingHelper.removeWoodToLatex(extractorEntry.getItemStack());
            }
        });
        ExtractorEntry.EXTRACTOR_ENTRIES.sort(Comparator.comparingInt(o -> ((ExtractorEntry)o).getFluidStack().amount).reversed());
    }

    public static void loadSludgeRefinerEntries() {
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Items.field_151119_aD), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150435_aG), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150346_d), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150351_n), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((Block)Blocks.field_150391_bh), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150346_d, 1, 2), 1));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((Block)Blocks.field_150354_m), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack((Block)Blocks.field_150354_m, 1, 1), 4));
        IndustrialForegoingHelper.addSludgeRefinerEntry(new SludgeEntry(new ItemStack(Blocks.field_150425_aM), 4));
    }

    public static void loadProteinReactorEntries() {
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151147_al)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151082_bd)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151076_bf)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_179558_bo)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_179561_bm)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_179556_br)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151078_bh)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151110_aK)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151070_bp)));
        IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry(new ItemStack(Items.field_151147_al)));
        NonNullList stacks = NonNullList.func_191196_a();
        RecipeHandlers.getSubItems((NonNullList<ItemStack>)stacks, new ItemStack(Items.field_151115_aP));
        RecipeHandlers.getSubItems((NonNullList<ItemStack>)stacks, new ItemStack(Items.field_151144_bL));
        stacks.forEach(stack -> IndustrialForegoingHelper.addProteinReactorEntry(new ProteinReactorEntry((ItemStack)stack)));
    }

    public static void loadFluidDictionaryEntries() {
        RecipeHandlers.addFluidEntryDoubleDirectional("essence", "xpjuice", 1.0);
        RecipeHandlers.addFluidEntryDoubleDirectional("essence", "experience", 1.0);
        RecipeHandlers.addFluidEntryDoubleDirectional("xpjuice", "experience", 1.0);
    }

    public static void loadWoodToLatexEntries() {
        RecipeHandlers.tryToAddWoodToLatex("ic2:rubber_wood", new FluidStack((Fluid)FluidsRegistry.LATEX, 4));
        RecipeHandlers.tryToAddWoodToLatex("techreborn:rubber_log", new FluidStack((Fluid)FluidsRegistry.LATEX, 4));
        IndustrialForegoingHelper.addWoodToLatex(new ExtractorEntry(new ItemStack(Blocks.field_150363_s), new FluidStack((Fluid)FluidsRegistry.LATEX, 3)));
        IndustrialForegoingHelper.addWoodToLatex(new ExtractorEntry(new ItemStack(Blocks.field_150363_s, 1, 1), new FluidStack((Fluid)FluidsRegistry.LATEX, 2)));
        RecipeHandlers.getRealOredictedItems("logWood").forEach(stack -> IndustrialForegoingHelper.addWoodToLatex(new ExtractorEntry((ItemStack)stack, new FluidStack((Fluid)FluidsRegistry.LATEX, 1))));
        RecipeHandlers.getRealOredictedWood("logWood").forEach(stack -> IndustrialForegoingHelper.addWoodToLatex(new ExtractorEntry((ItemStack)stack, new FluidStack((Fluid)FluidsRegistry.LATEX, 1))));
    }

    public static void loadOreEntries() {
        for (String s : OreDictionary.getOreNames()) {
            if (s.startsWith("ore") && !OreDictionary.getOres((String)s).isEmpty() && OreDictionary.doesOreNameExist((String)("dust" + s.replace("ore", ""))) && OreDictionary.getOres((String)("dust" + s.replace("ore", ""))).isEmpty()) continue;
        }
    }

    public static void addFluidEntryDoubleDirectional(String fluidInput, String fluidOutput, double ratio) {
        IndustrialForegoingHelper.addFluidDictionaryEntry(new FluidDictionaryEntry(fluidInput, fluidOutput, ratio));
        IndustrialForegoingHelper.addFluidDictionaryEntry(new FluidDictionaryEntry(fluidOutput, fluidInput, 1.0 / ratio));
    }

    public static NonNullList<ItemStack> getRealOredictedWood(String oredit) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (ItemStack ore : OreDictionary.getOres((String)oredit)) {
            stacks.add((Object)ore);
        }
        return stacks;
    }

    public static NonNullList<ItemStack> getRealOredictedItems(String oredit) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (ItemStack ore : OreDictionary.getOres((String)oredit)) {
            if (ore.func_77960_j() == Short.MAX_VALUE && ore.func_77973_b().func_77640_w() != null) {
                ore.func_77973_b().func_150895_a(ore.func_77973_b().func_77640_w(), stacks);
                continue;
            }
            stacks.add((Object)ore);
            break;
        }
        return stacks;
    }

    public static void getSubItems(NonNullList<ItemStack> list, ItemStack stack) {
        if (stack.func_77973_b().func_77640_w() != null) {
            stack.func_77973_b().func_150895_a(stack.func_77973_b().func_77640_w(), list);
        }
    }

    public static void tryToAddWoodToLatex(String string, FluidStack stack) {
        Block block = Block.func_149684_b((String)string);
        if (block != null) {
            IndustrialForegoingHelper.addWoodToLatex(new ExtractorEntry(new ItemStack(block), stack));
        }
    }
}

