/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import appeng.tile.misc.TileInterface;
import appeng.tile.networking.TileCableBus;
import codechicken.enderstorage.tile.TileEnderChest;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.client.infopiece.DyeTankInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.WorkUtils;
import cpw.mods.ironchest.common.tileentity.chest.TileEntityIronChest;
import java.util.ArrayList;
import java.util.List;
import mekanism.common.tile.TileEntityBin;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.DyeUtils;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import org.torgy.torgo.utils.AdvancementWorldData;

public class DyeMixerTile
extends CustomElectricMachine {
    private ItemStackHandler inputDyes;
    private ItemStackHandler lens;
    private ItemStackHandler output;
    private int rainbow;
    private int r;
    private int g;
    private int b;
    private String playerUUID = null;
    private int tickCounter = 0;

    public DyeMixerTile() {
        super(DyeMixerTile.class.getName().hashCode());
    }

    public void setOwner(String inputUUID) {
        this.playerUUID = inputUUID;
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inputDyes = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                DyeMixerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inputDyes, EnumDyeColor.RED, "Dye items", new BoundingRectangle(46, 25, 64, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_82833_r().matches("Dye Mixer Gel");
            }

            public boolean canExtractItem(int slot) {
                return false;
            }

            public List<Slot> getSlots(BasicTeslaContainer container) {
                ArrayList<Slot> slots = new ArrayList<Slot>();
                BoundingRectangle box = this.getBoundingBox();
                slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 0, box.getLeft() + 1 + 0, box.getTop() + 1));
                return slots;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
                ArrayList<IGuiContainerPiece> pieces = new ArrayList<IGuiContainerPiece>();
                BoundingRectangle box = this.getBoundingBox();
                pieces.add((IGuiContainerPiece)new TiledRenderedGuiPiece(box.getLeft() + 0, box.getTop(), 18, 18, 1, 1, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 108, 225, (new EnumDyeColor[]{EnumDyeColor.RED, EnumDyeColor.GREEN, EnumDyeColor.BLUE})[0]));
                return pieces;
            }
        });
        this.addInventoryToStorage(this.inputDyes, "inputDyes");
        this.lens = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                DyeMixerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.lens, EnumDyeColor.YELLOW, "Lens items", 132, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return DyeUtils.isDye((ItemStack)stack);
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.lens, "lens");
        this.output = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                DyeMixerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.output, EnumDyeColor.ORANGE, "Output items", 114, 61, 3, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.output, "output");
        this.registerSyncIntPart("rainbow", nbtTagInt -> {
            this.rainbow = nbtTagInt.func_150287_d();
        }, () -> new NBTTagInt(this.rainbow), SyncProviderLevel.GUI);
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> containerPieces = super.getGuiContainerPieces(container);
        containerPieces.add((IGuiContainerPiece)new DyeTankInfoPiece(this, (new EnumDyeColor[]{EnumDyeColor.RED})[0], 46, 46, 125, 72));
        return containerPieces;
    }

    @Override
    public void protectedUpdate() {
        super.protectedUpdate();
        ItemStack stack = this.inputDyes.getStackInSlot(0);
        if (!stack.func_190926_b() && this.rainbow < 100) {
            stack.func_190920_e(stack.func_190916_E() - 1);
            this.rainbow += 10;
        }
    }

    private boolean tileEntityIsSupported(TileEntity tileEntity) {
        return tileEntity instanceof TileInterface || tileEntity instanceof TileCableBus || tileEntity instanceof TileEntityIronChest || tileEntity instanceof TileEntityBin || tileEntity instanceof TileEntityChest || tileEntity instanceof TileEntityEnderChest || tileEntity instanceof TileEntityShulkerBox || tileEntity instanceof TileEnderChest;
    }

    private boolean checkAdvancementByColor(int color, String playerUUID) {
        switch (color) {
            case 3: {
                return AdvancementWorldData.checkAdvancement((String)(playerUUID + "triumph:95_venus/quartzore"));
            }
            case 6: {
                return AdvancementWorldData.checkAdvancement((String)(playerUUID + "triumph:90_mars/ore@desh"));
            }
            case 12: {
                return AdvancementWorldData.checkAdvancement((String)(playerUUID + "triumph:80_moon/meteor"));
            }
        }
        return true;
    }

    protected float performWork() {
        ++this.tickCounter;
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        ItemStack stack = this.lens.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return 0.0f;
        }
        int color = DyeUtils.metaFromStack((ItemStack)stack).orElse(0);
        if (this.tickCounter % 20 == 0) {
            this.handleTileEntityAboveAndBelow();
        }
        if (this.rainbow < 1) {
            return 0.0f;
        }
        boolean hasAdvancement = this.checkAdvancementByColor(color, this.playerUUID);
        if (!hasAdvancement) {
            return 0.0f;
        }
        ItemStack out = new ItemStack((Item)ItemRegistry.artificalDye, 1, color);
        if (ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)out, (boolean)true).func_190926_b()) {
            --this.rainbow;
            ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)out, (boolean)false);
            this.handleTileEntityAboveAndBelow();
            this.partialSync("rainbow", true);
            return 1.0f;
        }
        return 0.0f;
    }

    private void handleTileEntityAboveAndBelow() {
        this.handleTileEntityAtOffset(EnumFacing.UP);
        this.handleTileEntityAtOffset(EnumFacing.DOWN);
    }

    private void handleTileEntityAtOffset(EnumFacing offset) {
        IItemHandler itemHandler;
        BlockPos newPos = this.field_174879_c.func_177972_a(offset);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(newPos);
        if (tileEntity != null && this.tileEntityIsSupported(tileEntity) && (itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, offset.func_176734_d())) != null) {
            int i;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("torgo", "dyemixergel"));
            ItemStack defaultGel = new ItemStack(item);
            for (i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack result;
                ItemStack currentStack = itemHandler.getStackInSlot(i);
                if (!ItemStack.func_179545_c((ItemStack)currentStack, (ItemStack)defaultGel) || !(result = this.inputDyes.insertItem(0, currentStack, true)).func_190926_b() && !result.func_77969_a(defaultGel)) continue;
                this.inputDyes.insertItem(0, currentStack, false);
                currentStack.func_190918_g(1);
                if (!currentStack.func_190926_b()) continue;
                itemHandler.extractItem(i, 1, false);
            }
            block1: for (i = 0; i < this.output.getSlots(); ++i) {
                ItemStack stackInOutput = this.output.getStackInSlot(i);
                if (stackInOutput.func_190926_b()) continue;
                for (int j = 0; j < itemHandler.getSlots(); ++j) {
                    ItemStack remainder = itemHandler.insertItem(j, stackInOutput, false);
                    if (remainder.func_190926_b()) {
                        this.output.extractItem(i, stackInOutput.func_190916_E(), false);
                        continue block1;
                    }
                    if (remainder.func_190916_E() >= stackInOutput.func_190916_E()) continue;
                    this.output.extractItem(i, stackInOutput.func_190916_E() - remainder.func_190916_E(), false);
                    stackInOutput = remainder;
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound c = super.func_189515_b(compound);
        c.func_74768_a("rainbow", this.rainbow);
        if (this.playerUUID != null) {
            c.func_74778_a("owner", this.playerUUID);
        }
        return c;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("rainbow")) {
            this.rainbow = compound.func_74762_e("rainbow");
        }
        if (compound.func_74764_b("owner")) {
            this.playerUUID = compound.func_74779_i("owner");
        }
    }

    public int getRainbow() {
        return this.rainbow;
    }
}

