/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.config.CustomConfiguration;
import com.buuz135.industrial.entity.EntityPinkSlime;
import com.buuz135.industrial.gui.GuiHandler;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.ConveyorRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.event.ExperimentalCakeFeederTickHandler;
import com.buuz135.industrial.proxy.event.FakePlayerRideEntityHandler;
import com.buuz135.industrial.proxy.event.MobDeathHandler;
import com.buuz135.industrial.proxy.event.PlantInteractorHarvestDropsHandler;
import com.buuz135.industrial.proxy.event.WorldTickHandler;
import com.buuz135.industrial.proxy.network.ConveyorButtonInteractMessage;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.proxy.network.SpecialParticleMessage;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.CraftingUtils;
import com.buuz135.industrial.utils.RecipeUtils;
import com.buuz135.industrial.utils.apihandlers.CraftTweakerHelper;
import com.buuz135.industrial.utils.apihandlers.PlantRecollectableRegistryHandler;
import com.buuz135.industrial.utils.apihandlers.RecipeHandlers;
import com.buuz135.industrial.utils.apihandlers.json.ConfigurationConditionFactory;
import com.buuz135.industrial.utils.compat.baubles.ExperimentalCakeFeederBauble;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Bootstrap;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    public static final String CONTRIBUTORS_FILE = "https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json";
    public static Random random;
    public static List<String> CONTRIBUTORS;
    public static DamageSource custom;
    public static ResourceLocation PINK_SLIME_LOOT;
    public static File configFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl(String urlString) throws Exception {
        try (BufferedReader reader = null;){
            int read;
            URL url = new URL(urlString);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer buffer = new StringBuffer();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
    }

    public void init() {
        RecipeHandlers.loadBioReactorEntries();
        RecipeHandlers.loadSludgeRefinerEntries();
        RecipeHandlers.loadProteinReactorEntries();
        RecipeHandlers.loadFluidDictionaryEntries();
        RecipeHandlers.loadWoodToLatexEntries();
        RecipeHandlers.loadOreEntries();
    }

    public void postInit() {
        CraftingUtils.generateCrushedRecipes();
        BlockRegistry.createRecipes();
        ItemRegistry.createRecipes();
        RecipeUtils.generateConstants();
        RecipeHandlers.executeCraftweakerActions();
        LaserDrillEntry.loadLaserConfigs(configFolder);
        if (CustomConfiguration.config.hasChanged()) {
            CustomConfiguration.config.save();
        }
        BlockDispenser.field_149943_a.func_82595_a((Object)ItemRegistry.fertilizer, (Object)new Bootstrap.BehaviorDispenseOptional(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                this.field_190911_b = true;
                World world = source.func_82618_k();
                if (ItemDye.func_179234_a((ItemStack)stack, (World)world, (BlockPos)(blockpos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a))))) {
                    if (!world.field_72995_K) {
                        world.func_175718_b(2005, blockpos, 0);
                    }
                } else {
                    this.field_190911_b = false;
                }
                return stack;
            }
        });
    }

    public void preInit(FMLPreInitializationEvent event) {
        configFolder = event.getModConfigurationDirectory();
        LaserDrillEntry.addOreFile(new ResourceLocation("industrialforegoing", "default_ores.json"));
        IFRegistries.poke();
        CraftingHelper.register((ResourceLocation)new ResourceLocation("industrialforegoing", "configuration_value"), (IConditionFactory)new ConfigurationConditionFactory());
        random = new Random();
        FluidsRegistry.registerFluids();
        BlockRegistry.poke();
        ItemRegistry.poke();
        MinecraftForge.EVENT_BUS.register((Object)new BlockRegistry());
        MinecraftForge.EVENT_BUS.register((Object)new ItemRegistry());
        MinecraftForge.EVENT_BUS.register((Object)new ConveyorRegistry());
        MinecraftForge.EVENT_BUS.register((Object)new ExperimentalCakeFeederTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobDeathHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlantRecollectableRegistryHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FakePlayerRideEntityHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PlantInteractorHarvestDropsHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)IndustrialForegoing.instance, (IGuiHandler)new GuiHandler());
        int id = 0;
        IndustrialForegoing.NETWORK.registerMessage(ConveyorButtonInteractMessage.Handler.class, ConveyorButtonInteractMessage.class, ++id, Side.SERVER);
        IndustrialForegoing.NETWORK.registerMessage(ConveyorSplittingSyncEntityMessage.Handler.class, ConveyorSplittingSyncEntityMessage.class, ++id, Side.CLIENT);
        IndustrialForegoing.NETWORK.registerMessage(SpecialParticleMessage.Handler.class, SpecialParticleMessage.class, ++id, Side.CLIENT);
        CustomConfiguration.config = new Configuration(event.getSuggestedConfigurationFile());
        CustomConfiguration.config.load();
        CustomConfiguration.sync();
        CustomConfiguration.configValues = new HashMap();
        CustomConfiguration.configValues.put("useTEFrames", CustomConfiguration.config.getBoolean("useTEFrames", "general", true, "Adds recipes using Thermal Expansion frames"));
        CustomConfiguration.configValues.put("useEnderIOFrames", CustomConfiguration.config.getBoolean("useEnderIOFrames", "general", true, "Adds recipes using EnderIO frames"));
        CustomConfiguration.configValues.put("useOriginalFrames", CustomConfiguration.config.getBoolean("useOriginalFrames", "general", true, "Adds recipes using TeslaCoreLib frames"));
        CustomConfiguration.configValues.put("useMekanismFrames", CustomConfiguration.config.getBoolean("useMekanismFrames", "general", true, "Adds recipes using Mekanism Steel Casing"));
        CustomConfiguration.configValues.put("machines.wither_builder.HCWither", CustomConfiguration.config.getBoolean("HCWither", "machines.wither_builder", false, "If enabled, only the wither builder will be able to place wither skulls. That means that players won't be able to place wither skulls. The recipe will change, but that will need a restart."));
        if (Loader.isModLoaded((String)"crafttweaker")) {
            CraftTweakerHelper.register();
        }
        if (Loader.isModLoaded((String)"baubles")) {
            MinecraftForge.EVENT_BUS.register((Object)new ExperimentalCakeFeederBauble.Event());
        }
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("industrialforegoing", "pink_slime"), EntityPinkSlime.class, (String)"pink_slime", (int)135135, (Object)IndustrialForegoing.instance, (int)32, (int)1, (boolean)false, (int)10485860, (int)0xFFFFFF);
        PINK_SLIME_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("industrialforegoing", "entities/pink_slime"));
        try {
            new JsonParser().parse(CommonProxy.readUrl(CONTRIBUTORS_FILE)).getAsJsonObject().get("uuid").getAsJsonArray().forEach(jsonElement -> CONTRIBUTORS.add(jsonElement.getAsString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        CONTRIBUTORS = new ArrayList<String>();
        custom = new DamageSource("if_custom"){

            public ITextComponent func_151519_b(EntityLivingBase entityLivingBaseIn) {
                return new TextComponentTranslation("text.industrialforegoing.chat.slaughter_kill", new Object[]{entityLivingBaseIn.func_145748_c_().func_150254_d(), TextFormatting.RESET});
            }
        };
    }
}

