/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ExperimentalCakeFeederItem
extends IFCustomItem {
    public ExperimentalCakeFeederItem() {
        super("experimentalcake_feeder");
        this.func_77625_d(1);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        FluidHandlerItemStack handlerItemStack = new FluidHandlerItemStack(stack, 128000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid.getFluid().equals((Object)FluidsRegistry.EXPERIMENTALCAKE);
            }
        };
        handlerItemStack.fill(new FluidStack((Fluid)FluidsRegistry.EXPERIMENTALCAKE, 0), true);
        return handlerItemStack;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        FluidHandlerItemStack handlerItemStack = (FluidHandlerItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.DOWN);
        tooltip.add(this.getFilledAmount(stack) + "/" + handlerItemStack.getTankProperties()[0].getCapacity() + "mb of Experimental Cake");
    }

    public int getFilledAmount(ItemStack stack) {
        FluidHandlerItemStack handlerItemStack = (FluidHandlerItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.DOWN);
        return handlerItemStack.getFluid() == null ? 0 : handlerItemStack.getFluid().amount;
    }

    public void drain(ItemStack stack, int amount) {
        FluidHandlerItemStack handlerItemStack = (FluidHandlerItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, EnumFacing.DOWN);
        handlerItemStack.drain(new FluidStack((Fluid)FluidsRegistry.EXPERIMENTALCAKE, amount), true);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Item)this), new Object[]{"pip", "gig", " i ", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('i'), "ingotIron", Character.valueOf('g'), Items.field_151069_bo});
    }
}

