/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.book;

import com.buuz135.industrial.api.book.CategoryEntry;
import com.buuz135.industrial.api.book.IBookCategory;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public enum BookCategory implements IBookCategory
{
    GETTING_STARTED("getting_started", new ItemStack((Item)ItemRegistry.plastic)),
    GENERATORS("generators", new ItemStack((Block)BlockRegistry.petrifiedFuelGeneratorBlock)),
    AGRICULTURE("agriculture", new ItemStack((Block)BlockRegistry.cropRecolectorBlock)),
    ANIMAL_HUSBANDRY("animal_husbandry", new ItemStack(Items.field_151083_be)),
    MAGIC("magic", new ItemStack((Block)BlockRegistry.potionEnervatorBlock)),
    STORAGE("storage", new ItemStack((Block)BlockRegistry.blackHoleUnitBlock)),
    RESOURCE_PRODUCTION("resource_production", new ItemStack((Block)BlockRegistry.laserDrillBlock)),
    ITEM("items", new ItemStack((Item)ItemRegistry.rangeAddonItem, 1, 11)),
    CONVEYORS("conveyors", new ItemStack((Item)BlockRegistry.blockConveyor.getItem()));

    private String name;
    private ItemStack display;
    private Map<ResourceLocation, CategoryEntry> entries;

    private BookCategory(String name, ItemStack display) {
        this.name = new TextComponentTranslation("text.industrialforegoing.book.category." + name, new Object[0]).func_150254_d();
        this.display = display;
        this.entries = new LinkedHashMap<ResourceLocation, CategoryEntry>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getDisplay() {
        return this.display;
    }

    @Override
    public Map<ResourceLocation, CategoryEntry> getEntries() {
        return this.entries;
    }
}

