/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api;

import com.buuz135.industrial.api.extractor.ExtractorEntry;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.FluidDictionaryEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.api.recipe.SludgeEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;

public class IndustrialForegoingHelper {
    public static final String MOD_ID = "industrialforegoing";
    public static final String API_VERSION = "5";
    public static final String API_ID = "industrialforegoingapi";

    public static boolean addBioReactorEntry(BioReactorEntry entry) {
        if (BioReactorEntry.BIO_REACTOR_ENTRIES.stream().noneMatch(entry1 -> entry.doesStackMatch(entry1.getStack()))) {
            BioReactorEntry.BIO_REACTOR_ENTRIES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeBioReactorEntry(ItemStack stack) {
        return BioReactorEntry.BIO_REACTOR_ENTRIES.removeIf(entry -> entry.doesStackMatch(stack));
    }

    @Deprecated
    public static boolean addLaserDrillEntry(LaserDrillEntry entry) {
        try {
            throw new UnsupportedOperationException("Deprecated API Method since v1.12.0, use the new config for the Laser Drill located in config/laser_drill_ores");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static boolean removeLaserDrillEntry(ItemStack stack) {
        try {
            throw new UnsupportedOperationException("Deprecated API Method since v1.12.0, use the new config for the Laser Drill located in config/laser_drill_ores");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean addSludgeRefinerEntry(SludgeEntry entry) {
        if (SludgeEntry.SLUDGE_RECIPES.stream().noneMatch(entry1 -> entry1.getStack().func_77969_a(entry.getStack()))) {
            SludgeEntry.SLUDGE_RECIPES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeSludgeRefinerEntry(ItemStack stack) {
        return SludgeEntry.SLUDGE_RECIPES.removeIf(entry -> entry.getStack().func_77969_a(stack));
    }

    public static boolean addProteinReactorEntry(ProteinReactorEntry entry) {
        if (ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.stream().noneMatch(entry1 -> entry.doesStackMatch(entry1.getStack()))) {
            ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeProteinReactorEntry(ItemStack stack) {
        return ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.removeIf(entry -> entry.doesStackMatch(stack));
    }

    public static boolean addFluidDictionaryEntry(FluidDictionaryEntry entry) {
        if (FluidRegistry.isFluidRegistered((String)entry.getFluidOrigin()) && FluidRegistry.isFluidRegistered((String)entry.getFluidResult()) && FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.stream().noneMatch(entry1 -> entry1.getFluidOrigin().equals(entry.getFluidOrigin()) && entry1.getFluidResult().equals(entry.getFluidResult()))) {
            FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeFluidDictionaryEntry(FluidDictionaryEntry entry) {
        return FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.removeIf(entry1 -> entry1.getFluidOrigin().equals(entry.getFluidOrigin()) && entry1.getFluidResult().equals(entry.getFluidResult()));
    }

    public static boolean addWoodToLatex(ExtractorEntry entry) {
        if (ExtractorEntry.EXTRACTOR_ENTRIES.stream().noneMatch(extractorEntry -> extractorEntry.isEqual(entry.getItemStack()))) {
            ExtractorEntry.EXTRACTOR_ENTRIES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeWoodToLatex(ItemStack stack) {
        return ExtractorEntry.EXTRACTOR_ENTRIES.removeIf(extractorEntry -> extractorEntry.isEqual(stack));
    }
}

