/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.vanillafix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.utils.SSLUtils;
import org.dimdev.vanillafix.LoadingConfig;
import org.dimdev.vanillafix.crashes.DeobfuscatingRewritePolicy;
import org.dimdev.vanillafix.crashes.StacktraceDeobfuscator;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=-2147473648)
public class VanillaFixLoadingPlugin
implements IFMLLoadingPlugin {
    private static final Logger log = LogManager.getLogger((String)"VanillaFix");
    public static LoadingConfig config;

    private static void initStacktraceDeobfuscator() {
        File modDir = new File(Launch.minecraftHome, "config/vanillafix");
        modDir.mkdirs();
        log.info("Initializing StacktraceDeobfuscator");
        try {
            File mappings = new File(modDir, "methods-stable_39.csv");
            if (mappings.exists()) {
                log.info("Found MCP method mappings: " + mappings.getName());
            } else {
                log.info("Downloading MCP method mappings to: " + mappings.getName());
            }
            StacktraceDeobfuscator.init(mappings);
        }
        catch (Exception e) {
            log.error("Failed to get MCP data!", (Throwable)e);
        }
        log.info("Done initializing StacktraceDeobfuscator");
        DeobfuscatingRewritePolicy.install();
    }

    private static void initMixin() {
        MixinBootstrap.init();
        if (VanillaFixLoadingPlugin.config.bugFixes) {
            log.info("Initializing Bug Fix Mixins");
            Mixins.addConfiguration("mixins.vanillafix.bugs.json");
        }
        if (VanillaFixLoadingPlugin.config.crashFixes) {
            log.info("Initializing Crash Fix Mixins");
            Mixins.addConfiguration("mixins.vanillafix.crashes.json");
        }
        if (VanillaFixLoadingPlugin.config.profiler) {
            log.info("Initializing Profiler Improvement Mixins");
            Mixins.addConfiguration("mixins.vanillafix.profiler.json");
        }
        if (VanillaFixLoadingPlugin.config.textureFixes) {
            log.info("Initializing Texture Fix Mixins");
            Mixins.addConfiguration("mixins.vanillafix.textures.json");
        }
        if (VanillaFixLoadingPlugin.config.modSupport) {
            log.info("Initializing Mod Support Mixins");
            Mixins.addConfiguration("mixins.vanillafix.modsupport.json");
        }
    }

    private static void trustIdenTrust() {
        try (InputStream keyStoreInputStream = VanillaFixLoadingPlugin.class.getResourceAsStream("/dst_root_ca_x3.jks");){
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(keyStoreInputStream, "password".toCharArray());
            SSLUtils.trustCertificates(keyStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException();
        }
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        log.info("Initializing VanillaFix");
        config = new LoadingConfig(new File(Launch.minecraftHome, "config/vanillafix.cfg"));
        VanillaFixLoadingPlugin.trustIdenTrust();
        VanillaFixLoadingPlugin.initStacktraceDeobfuscator();
        VanillaFixLoadingPlugin.initMixin();
    }
}

