/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.mixin.internal;

import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import me.nallar.whocalled.WhoCalled;
import org.minimallycorrect.javatransformer.api.AccessFlags;
import org.minimallycorrect.javatransformer.api.Annotation;
import org.minimallycorrect.javatransformer.api.ClassInfo;
import org.minimallycorrect.javatransformer.api.ClassMember;
import org.minimallycorrect.javatransformer.api.ClassPath;
import org.minimallycorrect.javatransformer.api.FieldInfo;
import org.minimallycorrect.javatransformer.api.JavaTransformer;
import org.minimallycorrect.javatransformer.api.MethodInfo;
import org.minimallycorrect.javatransformer.api.Transformer;
import org.minimallycorrect.javatransformer.api.Type;
import org.minimallycorrect.javatransformer.internal.SimpleMethodInfo;
import org.minimallycorrect.mixin.Add;
import org.minimallycorrect.mixin.Inject;
import org.minimallycorrect.mixin.Injectable;
import org.minimallycorrect.mixin.Mixin;
import org.minimallycorrect.mixin.Overwrite;
import org.minimallycorrect.mixin.Synchronize;
import org.minimallycorrect.mixin.internal.ApplicationType;
import org.minimallycorrect.mixin.internal.Injector;
import org.minimallycorrect.mixin.internal.MixinError;

public class MixinApplicator {
    private static final Map<String, List<IndexedAnnotationApplier<? extends ClassMember>>> consumerMap = new HashMap<String, List<IndexedAnnotationApplier<? extends ClassMember>>>();
    private final Map<Path, List<String>> sources = new HashMap<Path, List<String>>();
    private final ClassPath classPath = new ClassPath();
    private final List<TargetedTransformer> transformers = new ArrayList<TargetedTransformer>();
    private Consumer<String> log = System.out::println;
    private boolean noMixinIsError = false;
    private boolean notAppliedIsError = true;
    private ApplicationType applicationType = ApplicationType.FINAL_PATCH;
    private JavaTransformer transformer;

    @NonNull
    private static MethodInfo get(MethodInfo from, ClassInfo target) {
        MethodInfo existing = target.get(from);
        if (existing == null) {
            throw new MixinError("Can't find method matching " + from + " in target " + target + "\nMethods in target: " + target.getMethods().collect(Collectors.toList()));
        }
        return existing;
    }

    private static void addAnnotationHandler(IndexedAnnotationApplier<?> applier, String name) {
        if (!name.contains(".")) {
            name = "org.minimallycorrect.mixin." + name;
        }
        consumerMap.computeIfAbsent(name, k -> new ArrayList()).add(applier);
    }

    private static void addAnnotationHandler(AnnotationApplier<?> applier, int index, String ... names) {
        for (String name : names) {
            MixinApplicator.addAnnotationHandler(new IndexedAnnotationApplier(index, applier), name);
        }
    }

    private static <T extends ClassMember> void addAnnotationHandler(Class<T> clazz, int index, AnnotationApplier<T> applier, String ... names) {
        MixinApplicator.addAnnotationHandler((MixinApplicator applicator, Annotation annotation, ? member, ClassInfo target) -> {
            if (clazz.isAssignableFrom(member.getClass())) {
                applier.apply(applicator, annotation, member, target);
            }
        }, index, names);
    }

    private static <T extends ClassMember> void addAnnotationHandler(Class<T> clazz, AnnotationApplier<T> applier, String ... names) {
        MixinApplicator.addAnnotationHandler(clazz, 0, applier, names);
    }

    private static <T extends ClassMember, A extends java.lang.annotation.Annotation> void addAnnotationHandler(Class<T> clazz, Class<A> annotationClass, int index, SpecificAnnotationApplier<T, A> applier) {
        MixinApplicator.addAnnotationHandler(clazz, index, (MixinApplicator applicator, Annotation annotation, T member, ClassInfo target) -> applier.apply(applicator, annotation.toInstance(annotationClass), member, target), annotationClass.getName());
    }

    private static <T extends ClassMember, A extends java.lang.annotation.Annotation> void addAnnotationHandler(Class<T> clazz, Class<A> annotationClass, SpecificAnnotationApplier<T, A> applier) {
        MixinApplicator.addAnnotationHandler(clazz, annotationClass, 0, applier);
    }

    private static boolean packageNameMatches(String className, List<String> packages) {
        for (String s : packages) {
            if (s != null && !className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private static String ignoreException(Supplier<String> supplier, String name) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return "Failed to get '" + name + "' due to " + t;
        }
    }

    private void logInfo(String s) {
        this.log.accept(s);
    }

    private Stream<SortableConsumer<ClassInfo>> handleAnnotation(ClassMember annotated) {
        return annotated.getAnnotations().stream().flatMap(annotation -> {
            List<IndexedAnnotationApplier<? extends ClassMember>> appliers = consumerMap.get(annotation.type.getClassName());
            if (appliers == null) {
                return null;
            }
            return appliers.stream().map(applier -> SortableConsumer.of(applier.sortIndex, target -> {
                try {
                    applier.apply(this, (Annotation)annotation, annotated, (ClassInfo)target);
                }
                catch (Exception e) {
                    throw new MixinError("Failed to apply handler for annotation '" + annotation.type.getClassName() + "' on '" + MixinApplicator.ignoreException(annotated::toString, "annotated") + "' in '" + annotated.getClassInfo().getName() + "' to '" + target.getName() + "'", e);
                }
            }));
        }).filter(Objects::nonNull);
    }

    public void addSource(String mixinPackage) {
        try {
            this.addSource(Class.forName(mixinPackage + ".package-info", true, WhoCalled.$.getCallingClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(Class<?> mixinSource) {
        this.addSource(JavaTransformer.pathFromClass(mixinSource), mixinSource.getPackage().getName());
    }

    public void addSource(Path mixinSource) {
        this.addSource(mixinSource, null);
    }

    public void addSource(Path mixinSource, String packageName) {
        List current = this.sources.computeIfAbsent(mixinSource, k -> new ArrayList());
        if (current.contains(null)) {
            return;
        }
        if (packageName == null) {
            current.clear();
        }
        current.add(packageName);
        this.transformer = null;
    }

    public JavaTransformer getMixinTransformer() {
        JavaTransformer transformer = this.transformer;
        if (transformer != null) {
            return transformer;
        }
        ArrayList<Transformer.TargetedTransformer> transformers = new ArrayList<Transformer.TargetedTransformer>();
        for (Map.Entry<Path, List<String>> pathListEntry : this.sources.entrySet()) {
            transformer = new JavaTransformer();
            transformer.addTransformer(classInfo -> {
                Transformer.TargetedTransformer source;
                if (MixinApplicator.packageNameMatches(classInfo.getName(), (List)pathListEntry.getValue()) && (source = this.processMixinSource(classInfo)) != null) {
                    transformers.add(source);
                }
            });
            transformer.setClassPath(this.classPath);
            transformer.parse(pathListEntry.getKey());
        }
        transformer = new JavaTransformer();
        transformer.setClassPath(this.classPath);
        transformers.forEach(arg_0 -> ((JavaTransformer)transformer).addTransformer(arg_0));
        if (this.notAppliedIsError) {
            transformer.getAfterTransform().add(javaTransformer -> this.checkForSkippedTransformers());
        }
        this.transformer = transformer;
        return this.transformer;
    }

    public void setLog(Consumer<String> log) {
        this.log.accept("Unregistering logger " + this.log + ", registering " + log);
        this.log = log;
    }

    private void checkForSkippedTransformers() {
        HashSet notRan = this.transformers.stream().filter(targetedTransformer -> !targetedTransformer.ran).collect(Collectors.toCollection(HashSet::new));
        if (!notRan.isEmpty()) {
            throw new MixinError(notRan.size() + " Transformers were not applied: " + this.transformers);
        }
    }

    private Transformer.TargetedTransformer processMixinSource(ClassInfo clazz) {
        List mixins = clazz.getAnnotations("org.minimallycorrect.mixin.Mixin");
        if (mixins.size() == 0) {
            if (this.noMixinIsError) {
                throw new RuntimeException("Class " + clazz.getName() + " is not an @Mixin");
            }
            return null;
        }
        if (mixins.size() > 1) {
            throw new MixinError(clazz.getName() + " can not use @Mixin multiple times");
        }
        Annotation mixin = (Annotation)mixins.get(0);
        String target = (String)mixin.values.get("target");
        if (target == null || target.isEmpty()) {
            target = clazz.getSuperType().getClassName();
        }
        if (!clazz.getAccessFlags().has(1024)) {
            throw new MixinError(clazz.getName() + " must be abstract to use @Mixin");
        }
        final List applicators = Stream.concat(Stream.of(clazz), clazz.getMembers()).flatMap(this::handleAnnotation).sorted().collect(Collectors.toList());
        this.logInfo("Found Mixin class '" + clazz.getName() + "' targeting class '" + target + " with " + applicators.size() + " applicators.");
        assert (!applicators.isEmpty());
        final String finalTarget = target;
        TargetedTransformer transformer = new TargetedTransformer(){

            public Collection<String> getTargetClasses() {
                return Collections.singletonList(finalTarget);
            }

            public void transform(ClassInfo classInfo) {
                this.ran = true;
                applicators.forEach(applicator -> applicator.accept(classInfo));
            }
        };
        this.transformers.add(transformer);
        return transformer;
    }

    public Map<Path, List<String>> getSources() {
        return this.sources;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public List<TargetedTransformer> getTransformers() {
        return this.transformers;
    }

    public Consumer<String> getLog() {
        return this.log;
    }

    public boolean isNoMixinIsError() {
        return this.noMixinIsError;
    }

    public boolean isNotAppliedIsError() {
        return this.notAppliedIsError;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setNoMixinIsError(boolean noMixinIsError) {
        this.noMixinIsError = noMixinIsError;
    }

    public void setNotAppliedIsError(boolean notAppliedIsError) {
        this.notAppliedIsError = notAppliedIsError;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MixinApplicator)) {
            return false;
        }
        MixinApplicator other = (MixinApplicator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Path, List<String>> this$sources = this.getSources();
        Map<Path, List<String>> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        ClassPath this$classPath = this.getClassPath();
        ClassPath other$classPath = other.getClassPath();
        if (this$classPath == null ? other$classPath != null : !this$classPath.equals(other$classPath)) {
            return false;
        }
        List<TargetedTransformer> this$transformers = this.getTransformers();
        List<TargetedTransformer> other$transformers = other.getTransformers();
        if (this$transformers == null ? other$transformers != null : !((Object)this$transformers).equals(other$transformers)) {
            return false;
        }
        Consumer<String> this$log = this.getLog();
        Consumer<String> other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        if (this.isNoMixinIsError() != other.isNoMixinIsError()) {
            return false;
        }
        if (this.isNotAppliedIsError() != other.isNotAppliedIsError()) {
            return false;
        }
        ApplicationType this$applicationType = this.getApplicationType();
        ApplicationType other$applicationType = other.getApplicationType();
        if (this$applicationType == null ? other$applicationType != null : !((Object)((Object)this$applicationType)).equals((Object)other$applicationType)) {
            return false;
        }
        JavaTransformer this$transformer = this.transformer;
        JavaTransformer other$transformer = other.transformer;
        return !(this$transformer == null ? other$transformer != null : !this$transformer.equals(other$transformer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MixinApplicator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Path, List<String>> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        ClassPath $classPath = this.getClassPath();
        result = result * 59 + ($classPath == null ? 43 : $classPath.hashCode());
        List<TargetedTransformer> $transformers = this.getTransformers();
        result = result * 59 + ($transformers == null ? 43 : ((Object)$transformers).hashCode());
        Consumer<String> $log = this.getLog();
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        result = result * 59 + (this.isNoMixinIsError() ? 79 : 97);
        result = result * 59 + (this.isNotAppliedIsError() ? 79 : 97);
        ApplicationType $applicationType = this.getApplicationType();
        result = result * 59 + ($applicationType == null ? 43 : ((Object)((Object)$applicationType)).hashCode());
        JavaTransformer $transformer = this.transformer;
        result = result * 59 + ($transformer == null ? 43 : $transformer.hashCode());
        return result;
    }

    public String toString() {
        return "MixinApplicator(sources=" + this.getSources() + ", classPath=" + this.getClassPath() + ", transformers=" + this.getTransformers() + ", log=" + this.getLog() + ", noMixinIsError=" + this.isNoMixinIsError() + ", notAppliedIsError=" + this.isNotAppliedIsError() + ", applicationType=" + (Object)((Object)this.getApplicationType()) + ", transformer=" + this.transformer + ")";
    }

    static {
        MixinApplicator.addAnnotationHandler(ClassInfo.class, Mixin.class, Integer.MIN_VALUE, (MixinApplicator applicator, A annotation, T member, ClassInfo target) -> applicator.logInfo("Handling class " + member.getName() + " with annotation " + annotation));
        MixinApplicator.addAnnotationHandler(ClassInfo.class, Mixin.class, 1, (MixinApplicator applicator, A annotation, T member, ClassInfo target) -> {
            if (applicator.applicationType == ApplicationType.FINAL_PATCH) {
                return;
            }
            List constructors = target.getConstructors().collect(Collectors.toList());
            if (!constructors.isEmpty() && constructors.stream().noneMatch(it -> it.getParameters().isEmpty())) {
                target.add(SimpleMethodInfo.of((AccessFlags)new AccessFlags(4), Collections.emptyList(), (Type)target.getType(), (String)"<init>", Collections.emptyList()));
            }
            boolean makePublic = annotation.makePublic();
            target.accessFlags(f -> f.makeAccessible(makePublic).without(16));
            target.getMembers().forEach(it -> it.accessFlags(f -> f.makeAccessible(makePublic).without(4112)));
        });
        MixinApplicator.addAnnotationHandler(FieldInfo.class, Add.class, 2, (MixinApplicator applicator, A annotation, T member, ClassInfo target) -> {
            String name = member.getName();
            if (!name.endsWith("_")) {
                throw new MixinError("Name of @Add-ed field must end with '_'");
            }
            target.add(member);
            FieldInfo added = target.get(member);
            added.setName(name.substring(0, name.length() - 1));
            added.accessFlags(it -> it.makeAccessible(false));
        });
        MixinApplicator.addAnnotationHandler(MethodInfo.class, Add.class, 2, (MixinApplicator applicator, A annotation, T member, ClassInfo target) -> target.add(member));
        MixinApplicator.addAnnotationHandler(MethodInfo.class, Overwrite.class, (MixinApplicator applicator, A annotation, T member, ClassInfo target) -> {
            MethodInfo existing = MixinApplicator.get(member, target);
            if (applicator.applicationType == ApplicationType.PRE_PATCH) {
                return;
            }
            target.remove(existing);
            target.add(member);
        });
        MixinApplicator.addAnnotationHandler(MethodInfo.class, Synchronize.class, (MixinApplicator applicator, A annotation, T member, ClassInfo target) -> target.get(member).accessFlags(it -> it.with(32)));
        MixinApplicator.addAnnotationHandler(MethodInfo.class, Inject.class, (MixinApplicator applicator, A annotation, T member, ClassInfo target) -> {
            String injectableName = annotation.injectable();
            List injectableMethods = member.getClassInfo().getMethods().filter(it -> {
                List injectables = it.getAnnotations(Injectable.class.getName());
                if (injectables.isEmpty()) {
                    return false;
                }
                String thisInjectableName = (String)((Annotation)injectables.get((int)0)).values.get("name");
                if (thisInjectableName == null) {
                    thisInjectableName = "";
                }
                return it.getName().equals(injectableName) && thisInjectableName.equals("") || it.getName().equals(thisInjectableName);
            }).collect(Collectors.toList());
            if (injectableMethods.size() != 1) {
                throw new MixinError("Couldn't find exactly 1 injectable with name " + injectableName + " in " + member.getClassInfo().getName());
            }
            Injector.inject(MixinApplicator.get(member, target), (MethodInfo)injectableMethods.get(0), annotation);
        });
    }

    private static abstract class TargetedTransformer
    implements Transformer.TargetedTransformer {
        boolean ran;

        private TargetedTransformer() {
        }

        public String toString() {
            Collection classes = this.getTargetClasses();
            return classes.size() == 1 ? (String)classes.iterator().next() : classes.toString();
        }
    }

    static class IndexedAnnotationApplier<T extends ClassMember> {
        final int sortIndex;
        final AnnotationApplier<T> applier;

        void apply(MixinApplicator applicator, Annotation annotation, T annotatedMember, ClassInfo mixinTarget) {
            this.applier.apply(applicator, annotation, annotatedMember, mixinTarget);
        }

        @ConstructorProperties(value={"sortIndex", "applier"})
        public IndexedAnnotationApplier(int sortIndex, AnnotationApplier<T> applier) {
            this.sortIndex = sortIndex;
            this.applier = applier;
        }
    }

    private static class SortableConsumer<T>
    implements Consumer<T>,
    Comparable {
        private final int sortIndex;
        private final Consumer<T> consumer;

        static <T> SortableConsumer<T> of(int sortIndex, Consumer<T> annotated) {
            return new SortableConsumer<T>(sortIndex, annotated);
        }

        int getSortIndex() {
            return this.sortIndex;
        }

        @Override
        public void accept(T t) {
            this.consumer.accept(t);
        }

        public int compareTo(Object other) {
            return Integer.compare(this.getSortIndex(), ((SortableConsumer)other).getSortIndex());
        }

        public String toString() {
            return this.sortIndex + ": " + this.consumer;
        }

        @ConstructorProperties(value={"sortIndex", "consumer"})
        public SortableConsumer(int sortIndex, Consumer<T> consumer) {
            this.sortIndex = sortIndex;
            this.consumer = consumer;
        }
    }

    @FunctionalInterface
    private static interface SpecificAnnotationApplier<T extends ClassMember, A extends java.lang.annotation.Annotation> {
        public void apply(MixinApplicator var1, A var2, T var3, ClassInfo var4);
    }

    @FunctionalInterface
    private static interface AnnotationApplier<T extends ClassMember> {
        public void apply(MixinApplicator var1, Annotation var2, T var3, ClassInfo var4);
    }
}

