/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.worlddata;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public abstract class AbstractWorldData<T extends AbstractWorldData<T>>
extends WorldSavedData {
    private static final Map<String, AbstractWorldData<?>> instances = new HashMap();

    protected AbstractWorldData(String name) {
        super(name);
    }

    public void save() {
        WorldServer world = DimensionManager.getWorld((int)0);
        world.func_72823_a(this.field_76190_i, (WorldSavedData)this);
        this.func_76185_a();
    }

    public abstract void clear();

    public static void clearInstances() {
        for (AbstractWorldData<?> data : instances.values()) {
            data.clear();
        }
        instances.clear();
    }

    public static int getDataCount() {
        return instances.size();
    }

    @Nonnull
    public static <T extends AbstractWorldData<T>> T getData(Class<T> clazz, String name) {
        WorldServer world = DimensionManager.getWorld((int)0);
        return AbstractWorldData.getData((World)world, clazz, name);
    }

    @Nonnull
    public static <T extends AbstractWorldData<T>> T getData(World world, Class<T> clazz, String name) {
        if (world.field_72995_K) {
            throw new RuntimeException("Don't access this client-side!");
        }
        AbstractWorldData data = instances.get(name);
        if (data != null) {
            return (T)((Object)data);
        }
        data = (AbstractWorldData)world.func_72943_a(clazz, name);
        if (data == null) {
            try {
                data = (AbstractWorldData)((Object)clazz.getConstructor(String.class).newInstance(name));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        instances.put(name, data);
        return (T)((Object)data);
    }
}

