/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import java.awt.Rectangle;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.network.PacketSetGuiStyle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class GuiSideWindow {
    protected GuiStyle style;
    protected Window sideWindow;
    private int sideLeft;
    private int sideTop;
    private int manual;
    private String manualNode;

    public GuiSideWindow(int manual, String manualNode) {
        this.manual = manual;
        this.manualNode = manualNode;
    }

    public void initGui(ModBase modBase, SimpleNetworkWrapper network, Minecraft mc, GuiScreen gui, int guiLeft, int guiTop, int xSize, int ySize) {
        this.style = McJtyLib.getPreferencesProperties((EntityPlayer)mc.field_71439_g).getStyle();
        this.setStyleTooltip();
        Panel sidePanel = new Panel(mc, (Gui)gui).setLayout(new PositionalLayout());
        this.sideLeft = guiLeft + xSize;
        this.sideTop = guiTop + (ySize - 20) / 2 - 8;
        sidePanel.setBounds(new Rectangle(this.sideLeft, this.sideTop, 0, 0));
        this.sideWindow = new Window(gui, sidePanel);
    }

    private void help(ModBase modBase, Minecraft mc) {
        EntityPlayerSP player = mc.field_71439_g;
        modBase.openManual((EntityPlayer)player, this.manual, this.manualNode);
    }

    private void setStyleTooltip() {
    }

    private void changeStyle(SimpleNetworkWrapper network) {
        int next = this.style.ordinal() + 1;
        if (next >= GuiStyle.values().length) {
            next = 0;
        }
        this.style = GuiStyle.values()[next];
        network.sendToServer((IMessage)new PacketSetGuiStyle(this.style.getStyle()));
        this.setStyleTooltip();
    }

    public Window getWindow() {
        return this.sideWindow;
    }
}

