/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lib.base.ModBase;
import mcjty.lib.datafix.fixes.TileEntityNamespace;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class McJtyRegister {
    private static final List<MBlock> blocks = new ArrayList<MBlock>();
    private static final Map<Block, MTile> tiles = new HashMap<Block, MTile>();
    private static final List<MItem> items = new ArrayList<MItem>();

    public static void registerLater(Block block, ModBase mod, @Nullable Function<Block, ItemBlock> itemBlockFactory) {
        blocks.add(new MBlock(block, mod, itemBlockFactory));
    }

    @Deprecated
    public static void registerLater(Block block, @Nullable Class<? extends TileEntity> tileEntityClass) {
        McJtyRegister.registerLater(block, tileEntityClass, true);
    }

    public static void registerLater(Block block, @Nullable Class<? extends TileEntity> tileEntityClass, boolean needsNamespaceFixer) {
        tiles.put(block, new MTile(tileEntityClass, needsNamespaceFixer));
    }

    public static void registerLater(Item item, ModBase mod) {
        items.add(new MItem(item, mod));
    }

    public static void registerBlocks(ModBase mod, IForgeRegistry<Block> registry) {
        McJtyRegister.registerBlocks(mod, registry, null, 1);
    }

    public static void registerBlocks(ModBase mod, IForgeRegistry<Block> registry, @Nullable ModFixs modFixs, int fixVersion) {
        HashMap<String, String> oldToNewIdMap = new HashMap<String, String>();
        for (MBlock mBlock : blocks) {
            if (!mBlock.getMod().getModId().equals(mod.getModId())) continue;
            Block block = mBlock.getBlock();
            registry.register((IForgeRegistryEntry)block);
            if (!tiles.containsKey(block)) continue;
            MTile tile = tiles.get(block);
            if (tile.getTileEntityClass() == null) {
                throw new RuntimeException("Bad tile entity registration for block: " + block.getRegistryName().toString());
            }
            String newId = block.getRegistryName().toString();
            GameRegistry.registerTileEntity(tile.getTileEntityClass(), (String)newId);
            if (!tile.isNeedsNamespaceFixer()) continue;
            String oldPath = mBlock.getMod().getModId() + "_" + block.getRegistryName().func_110623_a();
            oldToNewIdMap.put(oldPath, newId);
            oldToNewIdMap.put("minecraft:" + oldPath, newId);
        }
        if (!oldToNewIdMap.isEmpty()) {
            if (modFixs == null) {
                modFixs = FMLCommonHandler.instance().getDataFixer().init(mod.getModId(), fixVersion);
            }
            modFixs.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityNamespace(oldToNewIdMap, fixVersion));
        }
    }

    public static void registerItems(ModBase mod, IForgeRegistry<Item> registry) {
        for (MItem item : items) {
            if (!item.getMod().getModId().equals(mod.getModId())) continue;
            registry.register((IForgeRegistryEntry)item.getItem());
        }
        for (MBlock mBlock : blocks) {
            if (mBlock.getItemBlockFactory() == null || !mBlock.getMod().getModId().equals(mod.getModId())) continue;
            ItemBlock itemBlock = mBlock.getItemBlockFactory().apply(mBlock.getBlock());
            itemBlock.setRegistryName(mBlock.getBlock().getRegistryName());
            registry.register((IForgeRegistryEntry)itemBlock);
        }
    }

    private static class MItem {
        private final Item item;
        private final ModBase mod;

        public MItem(Item item, ModBase mod) {
            this.item = item;
            this.mod = mod;
        }

        public Item getItem() {
            return this.item;
        }

        public ModBase getMod() {
            return this.mod;
        }
    }

    private static class MBlock {
        private final Block block;
        private final ModBase mod;
        private final Function<Block, ItemBlock> itemBlockFactory;

        public MBlock(Block block, ModBase mod, Function<Block, ItemBlock> itemBlockFactory) {
            this.block = block;
            this.mod = mod;
            this.itemBlockFactory = itemBlockFactory;
        }

        public Block getBlock() {
            return this.block;
        }

        public ModBase getMod() {
            return this.mod;
        }

        public Function<Block, ItemBlock> getItemBlockFactory() {
            return this.itemBlockFactory;
        }
    }

    private static class MTile {
        private final Class<? extends TileEntity> tileEntityClass;
        private final boolean needsNamespaceFixer;

        public MTile(Class<? extends TileEntity> tileEntityClass, boolean needsNamespaceFixer) {
            this.tileEntityClass = tileEntityClass;
            this.needsNamespaceFixer = needsNamespaceFixer;
        }

        public Class<? extends TileEntity> getTileEntityClass() {
            return this.tileEntityClass;
        }

        public boolean isNeedsNamespaceFixer() {
            return this.needsNamespaceFixer;
        }
    }
}

