/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import org.jcodec.common.model.Picture;
import org.jcodec.common.tools.MathUtil;
import org.jcodec.scale.Transform;

public class Yuv420jToRgb
implements Transform {
    private static final int SCALEBITS = 10;
    private static final int ONE_HALF = 512;
    private static final int FIX_0_71414 = Yuv420jToRgb.FIX(0.71414);
    private static final int FIX_1_772 = Yuv420jToRgb.FIX(1.772);
    private static final int _FIX_0_34414 = -Yuv420jToRgb.FIX(0.34414);
    private static final int FIX_1_402 = Yuv420jToRgb.FIX(1.402);

    @Override
    public final void transform(Picture src, Picture dst) {
        int j;
        byte[] y = src.getPlaneData(0);
        byte[] u = src.getPlaneData(1);
        byte[] v = src.getPlaneData(2);
        byte[] data = dst.getPlaneData(0);
        int offLuma = 0;
        int offChroma = 0;
        int stride = dst.getWidth();
        for (int i = 0; i < dst.getHeight() >> 1; ++i) {
            for (int k = 0; k < dst.getWidth() >> 1; ++k) {
                int j2 = k << 1;
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j2], u[offChroma], v[offChroma], data, (offLuma + j2) * 3);
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j2 + 1], u[offChroma], v[offChroma], data, (offLuma + j2 + 1) * 3);
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j2 + stride], u[offChroma], v[offChroma], data, (offLuma + j2 + stride) * 3);
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j2 + stride + 1], u[offChroma], v[offChroma], data, (offLuma + j2 + stride + 1) * 3);
                ++offChroma;
            }
            if ((dst.getWidth() & 1) != 0) {
                j = dst.getWidth() - 1;
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j], u[offChroma], v[offChroma], data, (offLuma + j) * 3);
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j + stride], u[offChroma], v[offChroma], data, (offLuma + j + stride) * 3);
                ++offChroma;
            }
            offLuma += 2 * stride;
        }
        if ((dst.getHeight() & 1) != 0) {
            for (int k = 0; k < dst.getWidth() >> 1; ++k) {
                j = k << 1;
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j], u[offChroma], v[offChroma], data, (offLuma + j) * 3);
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j + 1], u[offChroma], v[offChroma], data, (offLuma + j + 1) * 3);
                ++offChroma;
            }
            if ((dst.getWidth() & 1) != 0) {
                int j3 = dst.getWidth() - 1;
                Yuv420jToRgb.YUVJtoRGB(y[offLuma + j3], u[offChroma], v[offChroma], data, (offLuma + j3) * 3);
                ++offChroma;
            }
        }
    }

    private static final int FIX(double x) {
        return (int)(x * 1024.0 + 0.5);
    }

    public static final void YUVJtoRGB(byte y, byte cb, byte cr, byte[] data, int off) {
        int y_ = y + 128 << 10;
        int add_r = FIX_1_402 * cr + 512;
        int add_g = _FIX_0_34414 * cb - FIX_0_71414 * cr + 512;
        int add_b = FIX_1_772 * cb + 512;
        int r = y_ + add_r >> 10;
        int g = y_ + add_g >> 10;
        int b = y_ + add_b >> 10;
        data[off] = (byte)MathUtil.clip(r - 128, -128, 127);
        data[off + 1] = (byte)MathUtil.clip(g - 128, -128, 127);
        data[off + 2] = (byte)MathUtil.clip(b - 128, -128, 127);
    }
}

