/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.platform.Platform;

public class MdtaBox
extends Box {
    private static final String FOURCC = "mdta";
    private String key;

    public MdtaBox(Header header) {
        super(header);
    }

    public static MdtaBox createMdtaBox(String key) {
        MdtaBox box = new MdtaBox(Header.createHeader(FOURCC, 0L));
        box.key = key;
        return box;
    }

    @Override
    public void parse(ByteBuffer buf) {
        this.key = Platform.stringFromBytes(NIOUtils.toArray(NIOUtils.readBuf(buf)));
    }

    public String getKey() {
        return this.key;
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        out.put(this.key.getBytes());
    }

    @Override
    public int estimateSize() {
        return this.key.getBytes().length;
    }

    public static String fourcc() {
        return FOURCC;
    }
}

