/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="extraalchemy")
public class ModConfig {
    @Config.RequiresMcRestart
    @Config.LangKey(value="extraalchemy.config.options")
    public static Options options = new Options();
    @Config.RequiresMcRestart
    @Config.LangKey(value="extraalchemy.config.potions")
    public static Potions potions = new Potions();
    @Config.LangKey(value="extraalchemy.config.client")
    public static Client client = new Client();
    private static String[] c_names = new String[]{"allowPotionCombining", "allowPotionSplitting", "breakingPotions", "enable_potion_bag", "useNewVials", "respectSolegnolias", "p_charged_level1", "p_charged_level2", "p_cheatDeath", "p_combustion", "p_concentration", "p_crumbling", "p_dispel", "p_dislocation", "p_freezing", "p_fuse", "p_gravity", "p_hurry", "p_learning", "p_leech", "p_magnetism", "p_pacifism", "p_photosynthesis", "p_piper", "p_recall", "p_reincarnation", "p_return", "p_sails", "p_sinking", "p_beheading", "p_pain", "p_push", "p_pull"};

    public static long getConfigSignature() {
        long status = 0L;
        if (ModConfig.options.allowPotionCombining) {
            status |= 1L;
        }
        if (ModConfig.options.allowPotionSplitting) {
            status |= 2L;
        }
        if (ModConfig.options.breakingPotions) {
            status |= 4L;
        }
        if (ModConfig.options.enable_potion_bag) {
            status |= 8L;
        }
        if (ModConfig.options.respectSolegnolias) {
            status |= 0x20L;
        }
        if (ModConfig.potions.p_charged_level1) {
            status |= 0x40L;
        }
        if (ModConfig.potions.p_charged_level2) {
            status |= 0x80L;
        }
        if (ModConfig.potions.p_cheatDeath) {
            status |= 0x100L;
        }
        if (ModConfig.potions.p_combustion) {
            status |= 0x200L;
        }
        if (ModConfig.potions.p_concentration) {
            status |= 0x400L;
        }
        if (ModConfig.potions.p_crumbling) {
            status |= 0x800L;
        }
        if (ModConfig.potions.p_dispel) {
            status |= 0x1000L;
        }
        if (ModConfig.potions.p_dislocation) {
            status |= 0x2000L;
        }
        if (ModConfig.potions.p_freezing) {
            status |= 0x4000L;
        }
        if (ModConfig.potions.p_fuse) {
            status |= 0x8000L;
        }
        if (ModConfig.potions.p_gravity) {
            status |= 0x10000L;
        }
        if (ModConfig.potions.p_hurry) {
            status |= 0x20000L;
        }
        if (ModConfig.potions.p_learning) {
            status |= 0x40000L;
        }
        if (ModConfig.potions.p_leech) {
            status |= 0x80000L;
        }
        if (ModConfig.potions.p_magnetism) {
            status |= 0x100000L;
        }
        if (ModConfig.potions.p_pacifism) {
            status |= 0x200000L;
        }
        if (ModConfig.potions.p_photosynthesis) {
            status |= 0x400000L;
        }
        if (ModConfig.potions.p_piper) {
            status |= 0x800000L;
        }
        if (ModConfig.potions.p_recall) {
            status |= 0x1000000L;
        }
        if (ModConfig.potions.p_reincarnation) {
            status |= 0x2000000L;
        }
        if (ModConfig.potions.p_return) {
            status |= 0x4000000L;
        }
        if (ModConfig.potions.p_sails) {
            status |= 0x8000000L;
        }
        if (ModConfig.potions.p_sinking) {
            status |= 0x10000000L;
        }
        if (ModConfig.potions.p_beheading) {
            status |= 0x20000000L;
        }
        if (ModConfig.potions.p_pain) {
            status |= 0x40000000L;
        }
        if (ModConfig.potions.p_push) {
            status |= Integer.MIN_VALUE;
        }
        if (ModConfig.potions.p_pull) {
            status |= 1L;
        }
        return status;
    }

    public static String getDifferences(long compare) {
        long current = ModConfig.getConfigSignature();
        String conflicts = "";
        int diffs = 0;
        for (int i = 0; i < c_names.length; ++i) {
            if ((current >> i & 1L) == (compare >> i & 1L)) continue;
            conflicts = conflicts + c_names[i] + "\n";
            if (++diffs < 5) continue;
            conflicts = conflicts + "[...]";
            break;
        }
        return conflicts.trim();
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onChanged(ConfigChangedEvent evt) {
            if (evt.getModID().equals("extraalchemy")) {
                ConfigManager.sync((String)"extraalchemy", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Potions {
        @Config.LangKey(value="potion.effect.push")
        public boolean p_push = true;
        @Config.LangKey(value="potion.effect.cheatDeath_quiescent")
        public boolean p_cheatDeath = true;
        @Config.LangKey(value="potion.effect.combustion")
        public boolean p_combustion = true;
        @Config.LangKey(value="potion.effect.concentration")
        public boolean p_concentration = true;
        @Config.LangKey(value="potion.effect.crumbling")
        public boolean p_crumbling = true;
        @Config.LangKey(value="potion.effect.dislocation")
        public boolean p_dislocation = true;
        @Config.LangKey(value="potion.effect.freezing")
        public boolean p_freezing = true;
        @Config.LangKey(value="potion.effect.fuse")
        public boolean p_fuse = true;
        @Config.LangKey(value="potion.effect.hurry")
        public boolean p_hurry = true;
        @Config.LangKey(value="potion.effect.learning")
        public boolean p_learning = true;
        @Config.LangKey(value="potion.effect.magnetism")
        public boolean p_magnetism = true;
        @Config.LangKey(value="potion.effect.pacifism")
        public boolean p_pacifism = true;
        @Config.LangKey(value="potion.effect.photosynthesis")
        public boolean p_photosynthesis = true;
        @Config.LangKey(value="potion.effect.piper")
        public boolean p_piper = true;
        @Config.LangKey(value="potion.effect.recall")
        public boolean p_recall = true;
        @Config.LangKey(value="potion.effect.reincarnation")
        public boolean p_reincarnation = true;
        @Config.LangKey(value="potion.effect.return")
        public boolean p_return = true;
        @Config.LangKey(value="potion.effect.sinking")
        public boolean p_sinking = true;
        @Config.LangKey(value="potion.effect.gravity")
        public boolean p_gravity = true;
        @Config.LangKey(value="potion.effect.leech")
        public boolean p_leech = true;
        @Config.LangKey(value="potion.effect.sails")
        public boolean p_sails = true;
        @Config.LangKey(value="potion.effect.charged")
        public boolean p_charged_level1 = true;
        @Config.LangKey(value="potion.effect.charged2")
        public boolean p_charged_level2 = true;
        @Config.LangKey(value="potion.effect.beheading")
        public boolean p_beheading = true;
        @Config.LangKey(value="potion.effect.dispel")
        public boolean p_dispel = true;
        @Config.LangKey(value="potion.effect.pain")
        public boolean p_pain = true;
        @Config.LangKey(value="potion.effect.pull")
        public boolean p_pull = true;
    }

    public static class Client {
        @Config.Comment(value={"Choose what to toggle potion descriptions with"})
        public Mode descriptionMode = Mode.SHIFT;
        @Config.Comment(value={"Set to false to hide the bad joke in the potion tooltip"})
        public boolean showBadJoke = true;
        @Config.Comment(value={"Set to false to set static color for potion of cheat death"})
        public boolean rainbowCheatDeath = true;
    }

    public static class Options {
        @Config.Comment(value={"Set to true to prevent the magnetism potion from working around solegnolias from Botania (Might have a negative impact on performance)"})
        public boolean respectSolegnolias = true;
        @Config.Comment(value={"If set to true, this allows the creation of longer potions (and tipped arrows)"})
        public boolean allowPotionCombining = true;
        @Config.Comment(value={"If set to true, this allows the creation of shorter potions (and tipped arrows)"})
        public boolean allowPotionSplitting = true;
        @Config.Comment(value={"Set to false to disable hardcore cheat death"})
        public boolean hardcoreCheatDeath = true;
        @Config.Comment(value={"Set to false to disable random cheat death killing and set it on timer=0"})
        public boolean cheatDeathRandom = true;
        @Config.Comment(value={"Set to false to disable the recipe for potion bags"})
        public boolean enable_potion_bag = true;
        @Config.Comment(value={"Set to false to disable the recipe of vial potions"})
        public boolean breakingPotions = true;
        @Config.Comment(value={"If set to true a brewing stand will run not only on blaze powder but also a fire below will suffice"})
        public boolean useFireUndernathBrewingStand = true;
        @Config.Comment(value={"Set to true to log all the potions in your instance with their potion-type ID. Used to create custom recipes"})
        public boolean log_potion_types = false;
        @Config.Comment(value={"Set to false to disable the 10%XP increase for the potion of learning to prevent XP showers-like mechanic from giving infinite XP"})
        public boolean learningBoostsXP = true;
        @Config.Comment(value={"Set to false to remove the rings from the mod"})
        public boolean enablePotionRings = true;
        @Config.Comment(value={"Set to false to stop the ring from working as a bauble, and have them apply the effect from the inventory"})
        public boolean enableBaubleInteraction = true;
        @Config.Comment(value={"The amount of XP a level 1 ring should drain when the effect charges run out."})
        public int ringXpConsumptionFirstLevel = 2;
        @Config.Comment(value={"The amount of XP a level 1 ring should drain when the effect charges run out."})
        public int ringXpConsumptionSecondLevel = 3;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"The chance of a head dropping for a non-empowered potion of beheading (no glowstone added)"})
        public double beheadingChanceLower = 0.5;
        @Config.RangeDouble(min=0.0, max=1.0)
        @Config.Comment(value={"The chance of a head dropping for an empowered potion of beheading (higher levels of the potion)"})
        public double beheadingChanceHigher = 1.0;
    }

    public static enum Mode {
        F3H,
        SHIFT,
        CTRL,
        ALT,
        NONE;

    }
}

