/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.recipesystem.loader;

import com.google.common.collect.Lists;
import com.teamacronymcoders.base.recipesystem.Recipe;
import com.teamacronymcoders.base.recipesystem.loader.JsonRecipeLoader;
import com.teamacronymcoders.base.recipesystem.source.IRecipeSource;
import com.teamacronymcoders.base.recipesystem.source.RecipeSource;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class AssetJsonRecipeLoader
extends JsonRecipeLoader {
    private static AssetJsonRecipeLoader instance;
    private final IRecipeSource RECIPE_SOURCE = new RecipeSource("assets", true);

    public static AssetJsonRecipeLoader getInstance() {
        if (instance == null) {
            instance = new AssetJsonRecipeLoader();
        }
        return instance;
    }

    @Override
    public IRecipeSource getRecipeSource() {
        return this.RECIPE_SOURCE;
    }

    @Override
    public List<Recipe> loadRecipes() {
        return Loader.instance().getActiveModList().parallelStream().map(this::loadRecipesForMod).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Recipe> loadRecipesForMod(ModContainer mod) {
        JsonContext ctx = new JsonContext(mod.getModId());
        ArrayList recipes = Lists.newArrayList();
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/base/recipe_system"), root -> true, (root, file) -> {
            Recipe recipe = this.loadRecipe(ctx, (Path)root, (Path)file);
            if (recipe != null) {
                recipes.add(recipe);
            }
            return true;
        }, (boolean)true, (boolean)true);
        return recipes;
    }
}

