/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.common.block;

import com.google.common.collect.Lists;
import fluxnetworks.common.block.BlockFluxCore;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.tileentity.TileFluxConnector;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockSidedConnection
extends BlockFluxCore {
    public static final PropertyBoolFacing NORTH = PropertyBoolFacing.create("north", EnumFacing.NORTH);
    public static final PropertyBoolFacing EAST = PropertyBoolFacing.create("east", EnumFacing.EAST);
    public static final PropertyBoolFacing SOUTH = PropertyBoolFacing.create("south", EnumFacing.SOUTH);
    public static final PropertyBoolFacing WEST = PropertyBoolFacing.create("west", EnumFacing.WEST);
    public static final PropertyBoolFacing DOWN = PropertyBoolFacing.create("down", EnumFacing.DOWN);
    public static final PropertyBoolFacing UP = PropertyBoolFacing.create("up", EnumFacing.UP);
    public static final ArrayList<PropertyBoolFacing> faces = Lists.newArrayList((Object[])new PropertyBoolFacing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});

    public BlockSidedConnection(String name) {
        super(name);
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
        TileFluxConnector tile = (TileFluxConnector)world.func_175625_s(observerPos);
        if (!tile.func_145831_w().field_72995_K) {
            tile.updateTransfers(FluxUtils.getBlockDirection(observerPos, changedBlockPos));
        }
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileFluxCore tile = (TileFluxCore)worldIn.func_175625_s(pos);
        for (PropertyBoolFacing face : faces) {
            state = state.func_177226_a((IProperty)face, (Comparable)Boolean.valueOf(tile.connections[face.facing.func_176745_a()] == 1));
        }
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTED, NORTH, SOUTH, WEST, EAST, DOWN, UP});
    }

    public static class PropertyBoolFacing
    extends PropertyBool {
        public EnumFacing facing;

        protected PropertyBoolFacing(String name, EnumFacing facing) {
            super(name);
            this.facing = facing;
        }

        public static PropertyBoolFacing create(String name, EnumFacing facing) {
            return new PropertyBoolFacing(name, facing);
        }
    }
}

