/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.basic;

import com.google.common.collect.Lists;
import fluxnetworks.FluxConfig;
import fluxnetworks.FluxNetworks;
import fluxnetworks.api.gui.EnumFeedbackInfo;
import fluxnetworks.api.gui.EnumNavigationTabs;
import fluxnetworks.api.network.INetworkConnector;
import fluxnetworks.client.gui.GuiFluxAdminHome;
import fluxnetworks.client.gui.GuiFluxConfiguratorHome;
import fluxnetworks.client.gui.GuiFluxConnectorHome;
import fluxnetworks.client.gui.basic.GuiButtonCore;
import fluxnetworks.client.gui.basic.GuiFluxCore;
import fluxnetworks.client.gui.basic.GuiTextField;
import fluxnetworks.client.gui.button.NavigationButton;
import fluxnetworks.client.gui.tab.GuiTabConnections;
import fluxnetworks.client.gui.tab.GuiTabCreate;
import fluxnetworks.client.gui.tab.GuiTabDetailedSelection;
import fluxnetworks.client.gui.tab.GuiTabMembers;
import fluxnetworks.client.gui.tab.GuiTabSelection;
import fluxnetworks.client.gui.tab.GuiTabSettings;
import fluxnetworks.client.gui.tab.GuiTabStatistics;
import fluxnetworks.common.item.ItemAdminConfigurator;
import fluxnetworks.common.item.ItemConfigurator;
import fluxnetworks.common.registry.RegistrySounds;
import fluxnetworks.common.tileentity.TileFluxCore;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class GuiTabCore
extends GuiFluxCore {
    protected List<NavigationButton> navigationButtons = Lists.newArrayList();
    public EnumNavigationTabs[] navigationTabs;

    public GuiTabCore(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
        this.setDefaultTabs();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.navigationButtons.clear();
        this.buttonLists.add(this.navigationButtons);
    }

    public abstract EnumNavigationTabs getNavigationTab();

    public void setDefaultTabs() {
        this.navigationTabs = EnumNavigationTabs.values();
    }

    public void setNavigationTabs(EnumNavigationTabs[] navigationTabs) {
        this.navigationTabs = navigationTabs;
    }

    @Override
    protected void keyTypedMain(char c, int k) throws IOException {
        super.keyTypedMain(c, k);
        if ((k == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(k)) && this.textBoxes.stream().noneMatch(GuiTextField::isFocused)) {
            if (this.getNavigationTab() == EnumNavigationTabs.TAB_HOME) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else {
                GuiTabCore.switchTab(EnumNavigationTabs.TAB_HOME, this.player, this.connector);
                FluxNetworks.proxy.setFeedback(EnumFeedbackInfo.NONE, false);
                if (FluxConfig.enableButtonSound) {
                    this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)RegistrySounds.BUTTON_CLICK, (float)1.0f));
                }
            }
        }
    }

    @Override
    public void onButtonClicked(GuiButtonCore button, int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && button instanceof NavigationButton) {
            GuiTabCore.switchTab(((NavigationButton)button).tab, this.player, this.connector);
            if (FluxConfig.enableButtonSound) {
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)RegistrySounds.BUTTON_CLICK, (float)1.0f));
            }
        }
    }

    public void configureNavigationButtons(EnumNavigationTabs currentTab, EnumNavigationTabs[] availableTabs) {
        int posCount = 0;
        for (EnumNavigationTabs tab : availableTabs) {
            if (tab != EnumNavigationTabs.TAB_CREATE) {
                this.navigationButtons.add(new NavigationButton(12 + 18 * posCount, -16, tab));
                ++posCount;
                continue;
            }
            this.navigationButtons.add(new NavigationButton(148, -16, tab));
        }
        this.navigationButtons.get(currentTab.ordinal()).setMain();
    }

    public static void switchTab(EnumNavigationTabs tab, EntityPlayer player, INetworkConnector connector) {
        switch (tab) {
            case TAB_HOME: {
                if (connector instanceof TileFluxCore) {
                    FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluxConnectorHome(player, (TileFluxCore)connector));
                    break;
                }
                if (connector instanceof ItemAdminConfigurator.AdminConnector) {
                    FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluxAdminHome(player, connector));
                    break;
                }
                if (connector instanceof ItemConfigurator.NetworkConnector) {
                    FMLCommonHandler.instance().showGuiScreen((Object)new GuiFluxConfiguratorHome(player, (ItemConfigurator.NetworkConnector)connector));
                    break;
                }
                player.func_71053_j();
                break;
            }
            case TAB_SELECTION: {
                if (connector instanceof ItemAdminConfigurator.AdminConnector && FluxNetworks.proxy.detailed_network_view) {
                    FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabDetailedSelection(player, connector));
                    break;
                }
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabSelection(player, connector));
                break;
            }
            case TAB_CONNECTION: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabConnections(player, connector));
                break;
            }
            case TAB_STATISTICS: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabStatistics(player, connector));
                break;
            }
            case TAB_MEMBER: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabMembers(player, connector));
                break;
            }
            case TAB_SETTING: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabSettings(player, connector));
                break;
            }
            case TAB_CREATE: {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiTabCreate(player, connector));
            }
        }
    }
}

