/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.api.utils;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class Coord4D {
    private int x;
    private int y;
    private int z;
    private int dimension;

    public Coord4D(NBTTagCompound tag) {
        this.read(tag);
    }

    public Coord4D(TileEntity tile) {
        this.x = tile.func_174877_v().func_177958_n();
        this.y = tile.func_174877_v().func_177956_o();
        this.z = tile.func_174877_v().func_177952_p();
        this.dimension = tile.func_145831_w().field_73011_w.getDimension();
    }

    public Coord4D(ByteBuf buf) {
        this.read(buf);
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        tag.func_74768_a("dimension", this.dimension);
        return tag;
    }

    public void read(NBTTagCompound tag) {
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
        this.dimension = tag.func_74762_e("dimension");
    }

    public void write(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.dimension);
    }

    public void read(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.dimension = buf.readInt();
    }

    public String getStringInfo() {
        return "X: " + this.x + " Y: " + this.y + " Z: " + this.z + " Dim: " + this.dimension;
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Coord4D)) {
            return false;
        }
        Coord4D c = (Coord4D)obj;
        return this.x == c.x && this.y == c.y && this.z == c.z && this.dimension == c.dimension;
    }
}

