/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Longsnap {
    private static final String VERSION_FILE_NAME = "Kozem_versions.txt";
    private static final String TEMP_VERSION_FILE_NAME = ".Kozem_versions.txt";
    private static final String PROTOCOL = "https";
    private static final String DOMAIN = "minecraft.thetorg.org";
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final int READ_TIMEOUT_MS = 60000;
    static List<String> ignoreDeleteFiles = Arrays.asList("# LibLoader.jar", "InvTweaksTree.txt");

    public static void premain(String agentArgs, Instrumentation inst) throws Exception {
        Longsnap.longsnap();
    }

    public static void longsnap() throws Exception {
        File minecraftDir = Longsnap.getMinecraftDirectory();
        if (Longsnap.shouldSkipUpdate(minecraftDir)) {
            return;
        }
        File tempVersionFile = new File(minecraftDir, TEMP_VERSION_FILE_NAME);
        File versionFile = new File(minecraftDir, VERSION_FILE_NAME);
        if (!versionFile.exists()) {
            try {
                versionFile.createNewFile();
                FileWriter writer = new FileWriter(versionFile);
                writer.write("");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        URL versionFileURL = new URL(PROTOCOL, DOMAIN, "/minecraft/Kozem_versions.txt");
        try {
            Comparable<File> localFile;
            Path key;
            Longsnap.downloadFile(versionFileURL, tempVersionFile);
            List<String> serverVersionInfo = Files.readAllLines(Paths.get(tempVersionFile.toURI()), StandardCharsets.UTF_8);
            Map<Path, String> serverVersionMap = Longsnap.versionInfoToMap(serverVersionInfo);
            HashMap<Path, String> filesToDownload = new HashMap<Path, String>(serverVersionMap);
            List<String> localVersionInfo = Files.readAllLines(Paths.get(versionFile.toURI()), StandardCharsets.UTF_8);
            Map<Path, String> localVersionMap = Longsnap.versionInfoToMap(localVersionInfo);
            HashMap<Path, String> filesToDelete = new HashMap<Path, String>(localVersionMap);
            for (Map.Entry<Path, String> entry : localVersionMap.entrySet()) {
                key = entry.getKey();
                String value = entry.getValue();
                filesToDownload.remove(key, value);
            }
            for (Map.Entry<Path, String> entry : serverVersionMap.entrySet()) {
                key = entry.getKey();
                filesToDelete.remove(key);
            }
            for (Path path : serverVersionMap.keySet()) {
                localFile = new File(minecraftDir, path.toString());
                if (localFile.exists()) continue;
                filesToDownload.put(path, "none");
            }
            for (Map.Entry entry : filesToDownload.entrySet()) {
                Path filePath = (Path)entry.getKey();
                URL downloadUrl = new URL(PROTOCOL, DOMAIN, "/minecraft/" + filePath);
                File downloadFile = new File(minecraftDir, filePath.toString());
                Longsnap.downloadFile(downloadUrl, downloadFile);
            }
            for (String string : Arrays.asList("mods", "scripts")) {
                File[] filesInDirectory;
                File directory = new File(minecraftDir, string);
                if (!directory.exists() || !directory.isDirectory() || (filesInDirectory = directory.listFiles()) == null) continue;
                for (File file : filesInDirectory) {
                    if (!file.isFile()) continue;
                    Path relativePath = Paths.get(string + "/" + file.getName(), new String[0]);
                    if (ignoreDeleteFiles.contains(file.getName()) || serverVersionMap.containsKey(relativePath)) continue;
                    filesToDelete.put(relativePath, "none");
                }
            }
            for (Map.Entry entry : filesToDelete.entrySet()) {
                localFile = (Path)entry.getKey();
                Files.deleteIfExists((Path)localFile);
                System.out.println("Deleting file: " + localFile);
            }
            Files.move(Paths.get(tempVersionFile.toURI()), Paths.get(versionFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            System.out.println("Failed to download " + versionFileURL + ". Skipping update");
            e.printStackTrace();
        }
    }

    private static Map<Path, String> versionInfoToMap(List<String> versionInfo) {
        HashMap<Path, String> versionMap = new HashMap<Path, String>();
        for (String line : versionInfo) {
            String[] parts = line.split("  @  ");
            if (parts.length != 2) continue;
            versionMap.put(Paths.get(parts[1].trim(), new String[0]), parts[0].trim());
        }
        return versionMap;
    }

    private static File getMinecraftDirectory() throws Exception {
        File jarLocation = new File(Longsnap.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        File parentDir = jarLocation.getParentFile();
        File serverPropertiesFile = new File(parentDir, "server.properties");
        if (serverPropertiesFile.exists()) {
            return parentDir;
        }
        File minecraftDir = new File(parentDir.getParentFile(), ".minecraft");
        return minecraftDir;
    }

    private static boolean shouldSkipUpdate(File directory) {
        File doNotUpdateFile = new File(directory, "donotupdate");
        if (doNotUpdateFile.exists()) {
            System.out.println("donotupdate file exists in " + directory + ". Skipping update.");
            return true;
        }
        return false;
    }

    private static void downloadFile(URL tmpUrl, File destination) throws IOException {
        String fileSeparator = System.getProperty("file.separator");
        String[] pathComponents = tmpUrl.getFile().split("[/\\\\]");
        StringBuilder encodedPath = new StringBuilder();
        for (String component : pathComponents) {
            if (component.isEmpty()) continue;
            encodedPath.append(fileSeparator);
            encodedPath.append(URLEncoder.encode(component, "UTF-8").replace("+", "%20"));
        }
        String filePath = encodedPath.toString().replace(fileSeparator, "/");
        URL url = new URL(tmpUrl.getProtocol(), tmpUrl.getHost(), tmpUrl.getPort(), filePath, null);
        System.out.println("TORGO: " + tmpUrl + " " + destination + " " + pathComponents.toString() + " " + encodedPath + " " + url);
        System.out.println("V2 Downloading file FROM: " + url + " TO: " + destination);
        destination.getParentFile().mkdirs();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(60000);
        try (InputStream in = connection.getInputStream();
             FileOutputStream out = new FileOutputStream(destination);){
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
    }
}

