/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.tile;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.manager.ChunkLoaderManager;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;

public class TileChunkLoader
extends TileChunkLoaderBase {
    public int radius;
    public ChunkLoaderShape shape = ChunkLoaderShape.Square;

    public boolean setShapeAndRadius(ChunkLoaderShape newShape, int newRadius) {
        if (this.field_145850_b.field_72995_K) {
            this.radius = newRadius;
            this.shape = newShape;
            return true;
        }
        Set<ChunkPos> chunks = TileChunkLoader.getContainedChunks(newShape, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p(), newRadius);
        if (chunks.size() > ChunkLoaderManager.maxChunksPerLoader()) {
            return false;
        }
        if (this.powered) {
            this.radius = newRadius;
            this.shape = newShape;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            return true;
        }
        if (ChunkLoaderManager.canLoaderAdd(this, chunks)) {
            this.radius = newRadius;
            this.shape = newShape;
            ChunkLoaderManager.updateLoader(this);
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            return true;
        }
        return false;
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.shape.ordinal());
        packet.writeByte(this.radius);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.setShapeAndRadius(ChunkLoaderShape.values()[packet.readUByte()], packet.readUByte());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74774_a("radius", (byte)this.radius);
        tag.func_74774_a("shape", (byte)this.shape.ordinal());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.radius = tag.func_74771_c("radius");
        this.shape = ChunkLoaderShape.values()[tag.func_74771_c("shape")];
    }

    @Override
    public Set<ChunkPos> getChunks() {
        return TileChunkLoader.getContainedChunks(this.shape, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177952_p(), this.radius);
    }

    public static Set<ChunkPos> getContainedChunks(ChunkLoaderShape shape, int xCoord, int zCoord, int radius) {
        return shape.getLoadedChunks(xCoord >> 4, zCoord >> 4, radius - 1);
    }

    public int countLoadedChunks() {
        return this.getChunks().size();
    }

    @Override
    public void activate() {
        if (this.radius == 0) {
            this.radius = 1;
            this.shape = ChunkLoaderShape.Square;
            this.setShapeAndRadius(ChunkLoaderShape.Square, 2);
        }
        super.activate();
    }
}

