/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.render;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.thetorg.blocks.BigBinBlock;
import org.thetorg.blocks.BigBinTileEntity;

@SideOnly(value=Side.CLIENT)
public class RenderBigBin
extends TileEntitySpecialRenderer<BigBinTileEntity> {
    private final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    FontRenderer fontRenderer;
    float scale;
    float blockScaler;
    float blockOffsetLeft;
    float blockOffsetTop;
    float fontOffsetRight;
    float fontOffsetRightLock;
    float fontOffsetTop;
    float offsetRow;

    public RenderBigBin() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.scale = 0.015f;
        this.blockScaler = 0.75f;
        this.blockOffsetLeft = 0.17f;
        this.blockOffsetTop = 0.9355f;
        this.fontOffsetRight = 1.0f - this.blockOffsetLeft;
        this.fontOffsetRightLock = 0.43f;
        this.fontOffsetTop = 0.9f;
        this.offsetRow = 0.187f;
    }

    public void render(BigBinTileEntity tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        BlockPos pos;
        if (tileEntity.func_145837_r()) {
            return;
        }
        World world = tileEntity.func_145831_w();
        IBlockState state = world.func_180495_p(pos = tileEntity.func_174877_v());
        if (!(state.func_177230_c() instanceof BigBinBlock)) {
            return;
        }
        Block block = state.func_177230_c();
        EnumFacing facing = EnumFacing.NORTH;
        if (block instanceof BigBinBlock) {
            BigBinBlock bigBinBlock = (BigBinBlock)block;
            PropertyDirection propertyFacing = bigBinBlock.getFacing();
            facing = (EnumFacing)state.func_177229_b((IProperty)propertyFacing);
        }
        this.render(tileEntity, x, y, z, facing);
    }

    private ItemStack getItemType(BigBinTileEntity tileEntity, int i) {
        return tileEntity.itemsStored[i];
    }

    public void render(BigBinTileEntity tileEntity, double x, double y, double z, EnumFacing facing) {
        this.func_190053_a(true);
        ItemStack itemType = ItemStack.field_190927_a;
        int i = 0;
        while (true) {
            if (i >= BigBinTileEntity.internalStorageSlotCount) break;
            itemType = this.getItemType(tileEntity, i);
            if (itemType != null && !itemType.func_190926_b()) {
                GlStateManager.func_179094_E();
                this.performTransformations(x, y, z, facing, i, this.blockOffsetTop, this.blockOffsetLeft);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.001f);
                GlStateManager.func_179152_a((float)(this.scale * this.blockScaler), (float)(this.scale * this.blockScaler), (float)0.0f);
                this.renderItem.func_180450_b(itemType, 0, 0);
                GlStateManager.func_179121_F();
            }
            ++i;
        }
        String lockedSymbol = TextFormatting.GOLD + "\u26b7";
        int i2 = 0;
        while (true) {
            if (i2 >= BigBinTileEntity.internalStorageSlotCount) break;
            if (tileEntity.itemsLocked[i2]) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179136_a((float)-10.0f, (float)-10.0f);
                GlStateManager.func_179088_q();
                this.performTransformations(x, y, z, facing, i2, this.fontOffsetTop, this.fontOffsetRightLock - (float)this.fontRenderer.func_78256_a(lockedSymbol) * this.scale);
                GlStateManager.func_179152_a((float)this.scale, (float)(-this.scale), (float)this.scale);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179140_f();
                this.fontRenderer.func_78276_b(lockedSymbol, 0, 0, 1);
                GlStateManager.func_179145_e();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179113_r();
                GlStateManager.func_179121_F();
            }
            ++i2;
        }
        int count = 0;
        int i3 = 0;
        while (true) {
            if (i3 >= BigBinTileEntity.internalStorageSlotCount) break;
            itemType = this.getItemType(tileEntity, i3);
            if (itemType != null && !itemType.func_190926_b()) {
                count = tileEntity.itemsCount[i3];
                GlStateManager.func_179094_E();
                GlStateManager.func_179136_a((float)-10.0f, (float)-10.0f);
                GlStateManager.func_179088_q();
                String color = "\u00a77";
                if (tileEntity.itemsLocked[i3]) {
                    color = "\u00a72";
                }
                String formattedCount = tileEntity.getFormatCount(count);
                this.performTransformations(x, y, z, facing, i3, this.fontOffsetTop, this.fontOffsetRight - (float)this.fontRenderer.func_78256_a(formattedCount) * this.scale);
                GlStateManager.func_179152_a((float)this.scale, (float)(-this.scale), (float)this.scale);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179140_f();
                this.fontRenderer.func_78276_b(color + formattedCount, 0, 0, 1);
                GlStateManager.func_179145_e();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179113_r();
                GlStateManager.func_179121_F();
            }
            ++i3;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)tileEntity.tier.getR(), (float)tileEntity.tier.getG(), (float)tileEntity.tier.getB(), (float)tileEntity.tier.getAlpha());
        for (EnumFacing facing2 : EnumFacing.values()) {
            if (facing2 == EnumFacing.UP || facing2 == EnumFacing.DOWN) continue;
            this.drawSingleRectangle(facing2, x, y, z, -0.001, 0.1, 0.07, 0.3);
            this.drawSingleRectangle(facing2, x, y, z, 0.9299999999999999, 0.1, 1.001, 0.3);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        this.func_190053_a(false);
    }

    private void performTransformations(double x, double y, double z, EnumFacing facing, int i, double yOffset, double xOffset) {
        GlStateManager.func_179137_b((double)x, (double)(y + yOffset), (double)z);
        switch (facing) {
            case NORTH: {
                GlStateManager.func_179137_b((double)(1.0 - xOffset), (double)(-this.offsetRow * (float)i), (double)0.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179137_b((double)xOffset, (double)(-this.offsetRow * (float)i), (double)1.0);
                break;
            }
            case WEST: {
                GlStateManager.func_179137_b((double)0.0, (double)(-this.offsetRow * (float)i), (double)xOffset);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179137_b((double)1.0, (double)(-this.offsetRow * (float)i), (double)(1.0 - xOffset));
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
    }

    private void drawSingleRectangle(EnumFacing facing, double x, double y, double z, double minX, double minY, double maxX, double maxY) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        double offset = 0.001;
        switch (facing) {
            case NORTH: {
                bufferbuilder.func_181662_b(x + minX, y + minY, z - offset).func_181675_d();
                bufferbuilder.func_181662_b(x + minX, y + maxY, z - offset).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y + maxY, z - offset).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y + minY, z - offset).func_181675_d();
                break;
            }
            case SOUTH: {
                bufferbuilder.func_181662_b(x + minX, y + minY, z + 1.0 + offset).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y + minY, z + 1.0 + offset).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y + maxY, z + 1.0 + offset).func_181675_d();
                bufferbuilder.func_181662_b(x + minX, y + maxY, z + 1.0 + offset).func_181675_d();
                break;
            }
            case EAST: {
                bufferbuilder.func_181662_b(x + 1.0 + offset, y + minY, z + minX).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0 + offset, y + maxY, z + minX).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0 + offset, y + maxY, z + maxX).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0 + offset, y + minY, z + maxX).func_181675_d();
                break;
            }
            case WEST: {
                bufferbuilder.func_181662_b(x - offset, y + minY, z + minX).func_181675_d();
                bufferbuilder.func_181662_b(x - offset, y + minY, z + maxX).func_181675_d();
                bufferbuilder.func_181662_b(x - offset, y + maxY, z + maxX).func_181675_d();
                bufferbuilder.func_181662_b(x - offset, y + maxY, z + minX).func_181675_d();
                break;
            }
            case UP: {
                bufferbuilder.func_181662_b(x + minX, y + 1.0 + offset, z + maxX).func_181675_d();
                bufferbuilder.func_181662_b(x + minX, y + 1.0 + offset, z + minX).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y + 1.0 + offset, z + minX).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y + 1.0 + offset, z + maxX).func_181675_d();
                break;
            }
            case DOWN: {
                bufferbuilder.func_181662_b(x + minX, y - offset, z + minX).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y - offset, z + minX).func_181675_d();
                bufferbuilder.func_181662_b(x + maxX, y - offset, z + maxX).func_181675_d();
                bufferbuilder.func_181662_b(x + minX, y - offset, z + maxX).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }
}

