/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.quests;

import java.util.HashMap;
import java.util.Map;
import org.thetorg.quests.Objective;
import org.thetorg.quests.Quest;

public class QuestManager {
    private Map<Integer, Quest> questsById = new HashMap<Integer, Quest>();
    private Map<String, Integer> questDescriptionToId = new HashMap<String, Integer>();
    private int nextQuestId = 1;
    private int nextObjectiveId = 1;

    public Quest addQuest(String description) {
        int questId = this.nextQuestId++;
        Quest quest = new Quest(questId, description);
        this.questsById.put(questId, quest);
        this.questDescriptionToId.put(description, questId);
        return quest;
    }

    public Objective addObjectiveToQuest(int questId, String description) {
        Quest quest = this.questsById.get(questId);
        if (quest != null) {
            int objectiveId = this.nextObjectiveId++;
            Objective objective = new Objective(objectiveId, description);
            quest.addObjective(objective);
            return objective;
        }
        return null;
    }

    public Quest getQuestById(int id) {
        return this.questsById.get(id);
    }

    public Quest getQuestByDescription(String description) {
        Integer questId = this.questDescriptionToId.get(description);
        if (questId != null) {
            return this.questsById.get(questId);
        }
        return null;
    }

    public static void main(String[] args) {
        QuestManager questManager = new QuestManager();
        Quest quest1 = questManager.addQuest("Find the lost treasure");
        questManager.addObjectiveToQuest(quest1.getId(), "Find the map");
        questManager.addObjectiveToQuest(quest1.getId(), "Locate the treasure");
        Quest quest2 = questManager.addQuest("Defeat the dragon");
        questManager.addObjectiveToQuest(quest2.getId(), "Gather allies");
        questManager.addObjectiveToQuest(quest2.getId(), "Collect weapons");
        Quest retrievedQuest = questManager.getQuestById(quest1.getId());
        System.out.println("Retrieved Quest: " + retrievedQuest.getDescription());
    }
}

