/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.blocks;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.thetorg.blocks.BigBinItemBlock;
import org.thetorg.blocks.TheTorgBlocks;
import org.thetorg.utils.Tiers;
import org.thetorg.utils.Tools;

public class BigBinTileEntity
extends TileEntity
implements IItemHandler {
    public static int internalStorageSlotCount = 4;
    public Tiers tier = Tiers.LEVEL1;
    public ItemStack[] itemsStored = new ItemStack[internalStorageSlotCount];
    public int[] itemsCount = new int[internalStorageSlotCount];
    public boolean[] itemsLocked = new boolean[internalStorageSlotCount];
    public long lastTouched = System.currentTimeMillis();
    public ItemStack lastItem = ItemStack.field_190927_a;
    private long prevWorldTime = 0L;
    private ArrayList<BigBinTileEntity> nodes = new ArrayList();

    public BigBinTileEntity() {
        for (int i = 0; i < internalStorageSlotCount; ++i) {
            this.itemsStored[i] = ItemStack.field_190927_a;
            this.itemsLocked[i] = false;
            this.itemsCount[i] = 0;
        }
    }

    public boolean isLastTouchedRecent(ItemStack insertedItemStack) {
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - this.lastTouched;
        boolean itemsMatch = this.lastItem.func_77969_a(insertedItemStack);
        this.lastItem = insertedItemStack.func_77946_l();
        this.lastTouched = currentTime;
        return timeDiff <= 250L && itemsMatch;
    }

    public void lockSlot(int slot) {
        if (this.itemsLocked[slot]) {
            this.itemsLocked[slot] = false;
            if (this.itemsCount[slot] == 0) {
                this.itemsStored[slot] = ItemStack.field_190927_a;
            }
        } else {
            this.itemsLocked[slot] = true;
        }
        this.dataChanged();
    }

    public void dataChanged() {
        if (this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    private void updateCluster() {
        int i;
        if (this.field_145850_b == null) {
            return;
        }
        long curWorldTime = this.field_145850_b.func_72820_D();
        if (this.field_145850_b.field_72995_K || curWorldTime == this.prevWorldTime) {
            return;
        }
        this.nodes.clear();
        BlockPos tmpPos = this.func_174877_v();
        this.nodes.add(this);
        for (i = 1; i < this.field_145850_b.func_72940_L() && this.field_145850_b.func_180495_p(tmpPos = tmpPos.func_177984_a()).func_177230_c().equals((Object)TheTorgBlocks.bigBinBlock); ++i) {
            this.nodes.add((BigBinTileEntity)this.field_145850_b.func_175625_s(tmpPos));
        }
        tmpPos = this.func_174877_v();
        for (i = 1; i < this.field_145850_b.func_72940_L() && this.field_145850_b.func_180495_p(tmpPos = tmpPos.func_177977_b()).func_177230_c().equals((Object)TheTorgBlocks.bigBinBlock); ++i) {
            this.nodes.add((BigBinTileEntity)this.field_145850_b.func_175625_s(tmpPos));
        }
    }

    public boolean isValidSlot(int slot) {
        this.updateCluster();
        return slot >= 0 && slot < this.nodes.size() * internalStorageSlotCount;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < internalStorageSlotCount; ++i) {
            this.itemsStored[i] = new ItemStack(compound.func_74775_l("itemsStored" + i));
            this.itemsLocked[i] = compound.func_74767_n("itemsLocked" + i);
            this.itemsCount[i] = compound.func_74762_e("itemsCount" + i);
        }
        this.tier = Tiers.valueOf(compound.func_74779_i("Tier"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        for (int i = 0; i < internalStorageSlotCount; ++i) {
            compound.func_74782_a("itemsStored" + i, (NBTBase)this.itemsStored[i].func_77955_b(new NBTTagCompound()));
            compound.func_74757_a("itemsLocked" + i, this.itemsLocked[i]);
            compound.func_74768_a("itemsCount" + i, this.itemsCount[i]);
        }
        compound.func_74778_a("Tier", this.tier.name());
        return compound;
    }

    public int getSlots() {
        this.updateCluster();
        return this.nodes.size() * internalStorageSlotCount;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (!this.isValidSlot(slot)) {
            return ItemStack.field_190927_a;
        }
        int nodeEntry = slot / internalStorageSlotCount;
        int slotInNode = slot % internalStorageSlotCount;
        if (nodeEntry < 0 || nodeEntry >= this.nodes.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack returnStack = this.nodes.get((int)nodeEntry).itemsStored[slotInNode].func_77946_l();
        returnStack.func_190920_e(this.nodes.get((int)nodeEntry).itemsCount[slotInNode]);
        return returnStack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        return this.processItemInsertion(slot, stack, simulate);
    }

    private boolean isItemValidForSlot(int slot, ItemStack stack) {
        this.updateCluster();
        if (!this.isValidSlot(slot)) {
            return false;
        }
        int nodeEntry = slot / internalStorageSlotCount;
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.nodes.get((int)nodeEntry).itemsStored[slot %= internalStorageSlotCount], (ItemStack)stack)) {
            return true;
        }
        if (stack.func_77973_b() instanceof BigBinItemBlock) {
            return false;
        }
        if (this.nodes.get((int)nodeEntry).itemsStored[slot].func_190926_b() && !this.nodes.get((int)nodeEntry).itemsLocked[slot]) {
            for (int i = 0; i < internalStorageSlotCount; ++i) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.nodes.get((int)nodeEntry).itemsStored[i], (ItemStack)stack)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private ItemStack processItemInsertion(int slot, ItemStack stack, boolean simulate) {
        this.updateCluster();
        int nodeEntry = slot / internalStorageSlotCount;
        int add = Math.min(stack.func_190916_E(), this.nodes.get((int)nodeEntry).tier.getMaxStorage() - this.nodes.get((int)nodeEntry).itemsCount[slot %= internalStorageSlotCount]);
        if (!simulate) {
            if (!Tools.areItemsEqual(this.nodes.get((int)nodeEntry).itemsStored[slot], stack)) {
                this.nodes.get((int)nodeEntry).itemsStored[slot] = stack.func_77946_l();
                this.nodes.get((int)nodeEntry).itemsStored[slot].func_190920_e(1);
            }
            int n = slot;
            this.nodes.get((int)nodeEntry).itemsCount[n] = this.nodes.get((int)nodeEntry).itemsCount[n] + add;
            stack.func_190918_g(add);
            this.nodes.get(nodeEntry).dataChanged();
            return stack;
        }
        ItemStack simulatedStack = stack.func_77946_l();
        simulatedStack.func_190918_g(add);
        return simulatedStack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.isValidSlot(slot)) {
            return ItemStack.field_190927_a;
        }
        int nodeEntry = slot / internalStorageSlotCount;
        if (!this.nodes.get((int)nodeEntry).itemsStored[slot %= internalStorageSlotCount].func_190926_b()) {
            int removeCount = Math.min(amount, this.nodes.get((int)nodeEntry).itemsCount[slot]);
            ItemStack removed = this.nodes.get((int)nodeEntry).itemsStored[slot].func_77946_l();
            removed.func_190920_e(removeCount);
            if (!simulate) {
                int n = slot;
                this.nodes.get((int)nodeEntry).itemsCount[n] = this.nodes.get((int)nodeEntry).itemsCount[n] - removeCount;
                if (this.nodes.get((int)nodeEntry).itemsCount[slot] == 0 && !this.nodes.get((int)nodeEntry).itemsLocked[slot]) {
                    this.nodes.get((int)nodeEntry).itemsStored[slot] = ItemStack.field_190927_a;
                }
                this.nodes.get(nodeEntry).dataChanged();
            }
            return removed;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        int nodeEntry = slot / internalStorageSlotCount;
        return this.nodes.get((int)nodeEntry).tier.getMaxStorage();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public List<String> getBlockTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (true) {
            if (i >= internalStorageSlotCount) break;
            ItemStack stack = this.itemsStored[i];
            if (stack != null) {
                String displayName = stack.func_82833_r();
                String formattedCount = NumberFormat.getNumberInstance(Locale.US).format(this.itemsCount[i]);
                formattedCount = this.itemsLocked[i] ? TextFormatting.GOLD + "\u26b7\u202f" + TextFormatting.AQUA + formattedCount + TextFormatting.RESET : "\u202f\u202f\u202f\u202f\u202f" + TextFormatting.AQUA + formattedCount + TextFormatting.RESET;
                if (stack.func_190926_b()) {
                    displayName = "";
                } else if (stack.func_77973_b() instanceof ItemEnchantedBook) {
                    StringBuilder enchantments = new StringBuilder();
                    Map enchantmentsMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
                    for (Map.Entry enchantment : enchantmentsMap.entrySet()) {
                        if (enchantments.length() > 0) {
                            enchantments.append(", ");
                        }
                        enchantments.append(((Enchantment)enchantment.getKey()).func_77316_c(((Integer)enchantment.getValue()).intValue()));
                    }
                    displayName = "Book: " + enchantments.toString();
                }
                list.add("Row " + (i + 1) + ": " + formattedCount + " " + displayName);
            }
            ++i;
        }
        return list;
    }

    public String getMachineName() {
        return "BigBin " + this.tier.getLabel();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public String getFormatCount(int count) {
        return this.formatCount(count);
    }

    public String formatCount(int count) {
        if (count < 100000) {
            return Integer.toString(count);
        }
        if (count < 1000000) {
            return count / 1000 + "K";
        }
        if (count < 10000000) {
            return String.format("%.1fM", (double)count / 1000000.0);
        }
        if (count < 1000000000) {
            return count / 1000000 + "M";
        }
        return String.format("%.1fB", (double)count / 1.0E9);
    }
}

