/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.thetorg.blocks.BigBinTileEntity;
import org.thetorg.utils.Tiers;

public class BigBinItemBlock
extends ItemBlock {
    public BigBinItemBlock(Block block) {
        super(block);
        this.func_77625_d(64);
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Tier")) {
            String tierName = stack.func_77978_p().func_74779_i("Tier").toUpperCase();
            try {
                Tiers tier = Tiers.valueOf(tierName);
                String displayString = tier.getLabel();
                displayString = displayString.replace("(Lvl 1)", TextFormatting.GREEN + "(Lvl 1)" + TextFormatting.RESET);
                displayString = displayString.replace("(Lvl 2)", TextFormatting.RED + "(Lvl 2)" + TextFormatting.RESET);
                displayString = displayString.replace("(Lvl 3)", TextFormatting.AQUA + "(Lvl 3)" + TextFormatting.RESET);
                displayString = displayString.replace("(Lvl 4)", TextFormatting.LIGHT_PURPLE + "(Lvl 4)" + TextFormatting.RESET);
                displayString = displayString.replace("(Lvl 5)", TextFormatting.GOLD + "(Lvl 5)" + TextFormatting.RESET);
                return super.func_77653_i(stack) + " " + displayString;
            }
            catch (IllegalArgumentException e) {
                System.out.println("TORGO No tier enum constant matched for: " + tierName + e);
            }
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        if (itemstack.func_77977_a().matches("tile.bigbin")) {
            BigBinTileEntity bigBinTileEntity = new BigBinTileEntity();
            NBTTagCompound tagCompound = itemstack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
            }
            if (!tagCompound.func_74764_b("Tier")) {
                tagCompound.func_74778_a("Tier", "LEVEL1");
            }
            bigBinTileEntity.tier = Tiers.valueOf(tagCompound.func_74779_i("Tier"));
            int i = 0;
            while (true) {
                if (i >= BigBinTileEntity.internalStorageSlotCount) break;
                bigBinTileEntity.itemsStored[i] = new ItemStack(tagCompound.func_74775_l("Items" + i));
                bigBinTileEntity.itemsLocked[i] = tagCompound.func_74767_n("itemsLocked" + i);
                bigBinTileEntity.itemsCount[i] = tagCompound.func_74762_e("itemsCount" + i);
                ++i;
            }
            list.addAll(bigBinTileEntity.getBlockTooltip());
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("tier")) {
            int tier = tag.func_74762_e("tier");
            return tier > 0;
        }
        return super.func_77636_d(stack);
    }
}

