/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.helper;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import org.apache.commons.lang3.tuple.Pair;

public class RitualHelper {
    @CapabilityInject(value=IRitualStone.Tile.class)
    static Capability<IRitualStone.Tile> RUNE_CAPABILITY = null;

    public static boolean canCrystalActivate(Ritual ritual, int crystalLevel) {
        return ritual.getCrystalLevel() <= crystalLevel;
    }

    public static String getValidRitual(World world, BlockPos pos) {
        for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
                return BloodMagic.RITUAL_MANAGER.getId(ritual);
            }
        }
        return "";
    }

    public static EnumFacing getDirectionOfRitual(World world, BlockPos pos, Ritual ritual) {
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
            return direction;
        }
        return null;
    }

    public static boolean checkValidRitual(World world, BlockPos pos, Ritual ritual, EnumFacing direction) {
        if (ritual == null) {
            return false;
        }
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent component : components) {
            BlockPos newPos = pos.func_177971_a((Vec3i)component.getOffset(direction));
            if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return ((IRitualStone)block).isRuneType(world, pos, type);
        }
        if (tile instanceof IRitualStone.Tile) {
            return ((IRitualStone.Tile)tile).isRuneType(type);
        }
        if (tile != null && tile.hasCapability(RUNE_CAPABILITY, null)) {
            return ((IRitualStone.Tile)tile.getCapability(RUNE_CAPABILITY, null)).isRuneType(type);
        }
        return false;
    }

    public static boolean isRune(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return true;
        }
        if (tile instanceof IRitualStone.Tile) {
            return true;
        }
        return tile != null && tile.hasCapability(RUNE_CAPABILITY, null);
    }

    public static void setRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof IRitualStone) {
            ((IRitualStone)state.func_177230_c()).setRuneType(world, pos, type);
        } else if (tile instanceof IRitualStone.Tile) {
            ((IRitualStone.Tile)tile).setRuneType(type);
        } else if (tile != null && tile.hasCapability(RUNE_CAPABILITY, null)) {
            ((IRitualStone.Tile)tile.getCapability(RUNE_CAPABILITY, null)).setRuneType(type);
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static boolean createRitual(World world, BlockPos pos, EnumFacing direction, Ritual ritual, boolean safe) {
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        if (RitualHelper.abortConstruction(world, pos, direction, safe, components)) {
            return false;
        }
        IBlockState mrs = RegistrarBloodMagicBlocks.RITUAL_CONTROLLER.func_176223_P();
        world.func_175656_a(pos, mrs);
        RitualHelper.setRitualStones(direction, world, pos, components);
        return true;
    }

    public static boolean abortConstruction(World world, BlockPos pos, EnumFacing direction, boolean safe, List<RitualComponent> components) {
        for (RitualComponent component : components) {
            BlockPos offset = component.getOffset(direction);
            BlockPos newPos = pos.func_177971_a((Vec3i)offset);
            if (!world.func_189509_E(newPos) && (!safe || world.func_175623_d(newPos))) continue;
            return true;
        }
        return false;
    }

    public static boolean repairRitualFromRuins(TileMasterRitualStone tile, boolean safe) {
        EnumFacing direction;
        Ritual ritual = tile.getCurrentRitual();
        if (ritual == null) {
            Pair<Ritual, EnumFacing> pair = RitualHelper.getRitualFromRuins(tile);
            ritual = (Ritual)pair.getKey();
            direction = (EnumFacing)pair.getValue();
        } else {
            direction = tile.getDirection();
        }
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        if (RitualHelper.abortConstruction(world, pos, direction, safe, components)) {
            return false;
        }
        RitualHelper.setRitualStones(direction, world, pos, components);
        return true;
    }

    public static void setRitualStones(EnumFacing direction, World world, BlockPos pos, List<RitualComponent> gatheredComponents) {
        for (RitualComponent component : gatheredComponents) {
            BlockPos offset = component.getOffset(direction);
            BlockPos newPos = pos.func_177971_a((Vec3i)offset);
            int meta = component.getRuneType().ordinal();
            IBlockState newState = RegistrarBloodMagicBlocks.RITUAL_STONE.func_176203_a(meta);
            world.func_175656_a(newPos, newState);
        }
    }

    public static Pair<Ritual, EnumFacing> getRitualFromRuins(TileMasterRitualStone tile) {
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        Ritual possibleRitual = tile.getCurrentRitual();
        EnumFacing possibleDirection = tile.getDirection();
        int highestCount = 0;
        if (possibleRitual == null || possibleDirection == null) {
            for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
                for (EnumFacing direction : EnumFacing.field_176754_o) {
                    ArrayList components = Lists.newArrayList();
                    ritual.gatherComponents(components::add);
                    int currentCount = 0;
                    for (RitualComponent component : components) {
                        BlockPos newPos = pos.func_177971_a((Vec3i)component.getOffset(direction));
                        if (!RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
                        ++currentCount;
                    }
                    if (currentCount <= highestCount) continue;
                    highestCount = currentCount;
                    possibleRitual = ritual;
                    possibleDirection = direction;
                }
            }
        }
        return Pair.of((Object)possibleRitual, (Object)possibleDirection);
    }
}

