/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile.routing;

import WayofTime.bloodmagic.demonAura.WorldDemonWillHandler;
import WayofTime.bloodmagic.routing.IFluidFilter;
import WayofTime.bloodmagic.routing.IInputFluidRoutingNode;
import WayofTime.bloodmagic.routing.IInputItemRoutingNode;
import WayofTime.bloodmagic.routing.IItemFilter;
import WayofTime.bloodmagic.routing.IMasterRoutingNode;
import WayofTime.bloodmagic.routing.IOutputFluidRoutingNode;
import WayofTime.bloodmagic.routing.IOutputItemRoutingNode;
import WayofTime.bloodmagic.routing.IRoutingFilter;
import WayofTime.bloodmagic.routing.IRoutingNode;
import WayofTime.bloodmagic.routing.NodeHelper;
import WayofTime.bloodmagic.soul.EnumDemonWillType;
import WayofTime.bloodmagic.tile.TileInventory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileMasterRoutingNode
extends TileInventory
implements IMasterRoutingNode,
ITickable {
    public static final int tickRate = 20;
    private int currentInput;
    private TreeMap<BlockPos, List<BlockPos>> connectionMap = new TreeMap();
    private List<BlockPos> generalNodeList = new LinkedList<BlockPos>();
    private List<BlockPos> outputNodeList = new LinkedList<BlockPos>();
    private List<BlockPos> inputNodeList = new LinkedList<BlockPos>();

    public TileMasterRoutingNode() {
        super(0, "masterRoutingNode");
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.currentInput = this.func_145831_w().func_175676_y(this.field_174879_c);
        }
        if (this.func_145831_w().field_72995_K || this.func_145831_w().func_82737_E() % 20L != 0L) {
            return;
        }
        TreeMap outputMap = new TreeMap();
        TreeMap outputFluidMap = new TreeMap();
        for (BlockPos outputPos : this.outputNodeList) {
            LinkedList<IItemFilter> filterList;
            int priority;
            IRoutingFilter filter;
            IRoutingNode outputNode;
            TileEntity outputTile = this.func_145831_w().func_175625_s(outputPos);
            if (!this.isConnected(new LinkedList<BlockPos>(), outputPos)) continue;
            if (outputTile instanceof IOutputItemRoutingNode) {
                outputNode = (IOutputItemRoutingNode)outputTile;
                for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                    if (!outputNode.isInventoryConnectedToSide(enumFacing) || !outputNode.isOutput(enumFacing) || (filter = outputNode.getOutputFilterForSide(enumFacing)) == null) continue;
                    priority = outputNode.getPriority(enumFacing);
                    if (outputMap.containsKey(priority)) {
                        ((List)outputMap.get(priority)).add(filter);
                        continue;
                    }
                    filterList = new LinkedList<IItemFilter>();
                    filterList.add((IItemFilter)filter);
                    outputMap.put(priority, filterList);
                }
            }
            if (!(outputTile instanceof IOutputFluidRoutingNode)) continue;
            outputNode = (IOutputFluidRoutingNode)outputTile;
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                if (!outputNode.isTankConnectedToSide(enumFacing) || !outputNode.isFluidOutput(enumFacing) || (filter = outputNode.getOutputFluidFilterForSide(enumFacing)) == null) continue;
                priority = outputNode.getPriority(enumFacing);
                if (outputFluidMap.containsKey(priority)) {
                    ((List)outputFluidMap.get(priority)).add(filter);
                    continue;
                }
                filterList = new LinkedList();
                filterList.add((IItemFilter)filter);
                outputFluidMap.put(priority, filterList);
            }
        }
        TreeMap inputMap = new TreeMap();
        TreeMap inputFluidMap = new TreeMap();
        for (BlockPos inputPos : this.inputNodeList) {
            LinkedList<IItemFilter> filterList;
            int priority;
            IRoutingFilter filter;
            TileEntity inputTile = this.func_145831_w().func_175625_s(inputPos);
            if (!this.isConnected(new LinkedList<BlockPos>(), inputPos)) continue;
            if (inputTile instanceof IInputItemRoutingNode) {
                IInputItemRoutingNode iInputItemRoutingNode = (IInputItemRoutingNode)inputTile;
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    if (!iInputItemRoutingNode.isInventoryConnectedToSide(facing) || !iInputItemRoutingNode.isInput(facing) || (filter = iInputItemRoutingNode.getInputFilterForSide(facing)) == null) continue;
                    priority = iInputItemRoutingNode.getPriority(facing);
                    if (inputMap.containsKey(priority)) {
                        ((List)inputMap.get(priority)).add(filter);
                        continue;
                    }
                    filterList = new LinkedList<IItemFilter>();
                    filterList.add((IItemFilter)filter);
                    inputMap.put(priority, filterList);
                }
            }
            if (!(inputTile instanceof IInputFluidRoutingNode)) continue;
            IInputFluidRoutingNode iInputFluidRoutingNode = (IInputFluidRoutingNode)inputTile;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!iInputFluidRoutingNode.isTankConnectedToSide(facing) || !iInputFluidRoutingNode.isFluidInput(facing) || (filter = iInputFluidRoutingNode.getInputFluidFilterForSide(facing)) == null) continue;
                priority = iInputFluidRoutingNode.getPriority(facing);
                if (inputFluidMap.containsKey(priority)) {
                    ((List)inputFluidMap.get(priority)).add(filter);
                    continue;
                }
                filterList = new LinkedList();
                filterList.add((IItemFilter)filter);
                inputFluidMap.put(priority, filterList);
            }
        }
        int maxTransfer = this.getMaxTransferForDemonWill(WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, EnumDemonWillType.DEFAULT));
        int maxFluidTransfer = 1000;
        for (Map.Entry entry : outputMap.entrySet()) {
            List outputList = (List)entry.getValue();
            for (IItemFilter outputFilter : outputList) {
                for (Map.Entry inputEntry : inputMap.entrySet()) {
                    List inputList = (List)inputEntry.getValue();
                    for (IRoutingFilter inputFilter : inputList) {
                        if ((maxTransfer -= inputFilter.transferThroughInputFilter(outputFilter, maxTransfer)) > 0) continue;
                        return;
                    }
                }
            }
        }
        for (Map.Entry entry : outputFluidMap.entrySet()) {
            List outputList = (List)entry.getValue();
            for (IFluidFilter outputFilter : outputList) {
                for (Map.Entry inputEntry : inputFluidMap.entrySet()) {
                    List inputList = (List)inputEntry.getValue();
                    for (IRoutingFilter inputFilter : inputList) {
                        if ((maxFluidTransfer -= inputFilter.transferThroughInputFilter(outputFilter, maxFluidTransfer)) > 0) continue;
                        return;
                    }
                }
            }
        }
    }

    public int getMaxTransferForDemonWill(double will) {
        return 64;
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        NBTTagCompound posTag;
        super.serialize(tag);
        NBTTagList tags = new NBTTagList();
        for (BlockPos pos : this.generalNodeList) {
            posTag = new NBTTagCompound();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.func_74742_a((NBTBase)posTag);
        }
        tag.func_74782_a("generalList", (NBTBase)tags);
        tags = new NBTTagList();
        for (BlockPos pos : this.inputNodeList) {
            posTag = new NBTTagCompound();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.func_74742_a((NBTBase)posTag);
        }
        tag.func_74782_a("inputList", (NBTBase)tags);
        tags = new NBTTagList();
        for (BlockPos pos : this.outputNodeList) {
            posTag = new NBTTagCompound();
            posTag.func_74768_a("xCoord", pos.func_177958_n());
            posTag.func_74768_a("yCoord", pos.func_177956_o());
            posTag.func_74768_a("zCoord", pos.func_177952_p());
            tags.func_74742_a((NBTBase)posTag);
        }
        tag.func_74782_a("outputList", (NBTBase)tags);
        return tag;
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        BlockPos newPos;
        NBTTagCompound blockTag;
        int i;
        super.deserialize(tag);
        NBTTagList tags = tag.func_150295_c("generalList", 10);
        for (i = 0; i < tags.func_74745_c(); ++i) {
            blockTag = tags.func_150305_b(i);
            newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.generalNodeList.add(newPos);
        }
        tags = tag.func_150295_c("inputList", 10);
        for (i = 0; i < tags.func_74745_c(); ++i) {
            blockTag = tags.func_150305_b(i);
            newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.inputNodeList.add(newPos);
        }
        tags = tag.func_150295_c("outputList", 10);
        for (i = 0; i < tags.func_74745_c(); ++i) {
            blockTag = tags.func_150305_b(i);
            newPos = new BlockPos(blockTag.func_74762_e("xCoord"), blockTag.func_74762_e("yCoord"), blockTag.func_74762_e("zCoord"));
            this.outputNodeList.add(newPos);
        }
    }

    @Override
    public boolean isConnected(List<BlockPos> path, BlockPos nodePos) {
        TileEntity tile = this.func_145831_w().func_175625_s(nodePos);
        if (!(tile instanceof IRoutingNode)) {
            return false;
        }
        IRoutingNode node = (IRoutingNode)tile;
        List<BlockPos> connectionList = node.getConnected();
        path.add(nodePos);
        for (BlockPos testPos : connectionList) {
            if (path.contains(testPos)) continue;
            if (testPos.equals((Object)this.func_174877_v()) && node.isConnectionEnabled(testPos)) {
                return true;
            }
            if (!NodeHelper.isNodeConnectionEnabled(this.func_145831_w(), node, testPos) || !this.isConnected(path, testPos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnectionEnabled(BlockPos testPos) {
        return this.currentInput <= 0;
    }

    @Override
    public void addNodeToList(IRoutingNode node) {
        BlockPos newPos = node.getBlockPos();
        if (!this.generalNodeList.contains(newPos)) {
            this.generalNodeList.add(newPos);
        }
        if (node instanceof IInputItemRoutingNode && !this.inputNodeList.contains(newPos)) {
            this.inputNodeList.add(newPos);
        }
        if (node instanceof IOutputItemRoutingNode && !this.outputNodeList.contains(newPos)) {
            this.outputNodeList.add(newPos);
        }
    }

    @Override
    public void addConnections(BlockPos pos, List<BlockPos> connectionList) {
        for (BlockPos testPos : connectionList) {
            this.addConnection(pos, testPos);
        }
    }

    @Override
    public void addConnection(BlockPos pos1, BlockPos pos2) {
        LinkedList<BlockPos> list;
        if (this.connectionMap.containsKey(pos1) && !this.connectionMap.get(pos1).contains(pos2)) {
            this.connectionMap.get(pos1).add(pos2);
        } else {
            list = new LinkedList<BlockPos>();
            list.add(pos2);
            this.connectionMap.put(pos1, list);
        }
        if (this.connectionMap.containsKey(pos2) && !this.connectionMap.get(pos2).contains(pos1)) {
            this.connectionMap.get(pos2).add(pos1);
        } else {
            list = new LinkedList();
            list.add(pos1);
            this.connectionMap.put(pos2, list);
        }
    }

    @Override
    public void removeConnection(BlockPos pos1, BlockPos pos2) {
        List<BlockPos> posList;
        if (this.connectionMap.containsKey(pos1)) {
            posList = this.connectionMap.get(pos1);
            posList.remove(pos2);
            if (posList.isEmpty()) {
                this.connectionMap.remove(pos1);
            }
        }
        if (this.connectionMap.containsKey(pos2)) {
            posList = this.connectionMap.get(pos2);
            posList.remove(pos1);
            if (posList.isEmpty()) {
                this.connectionMap.remove(pos2);
            }
        }
    }

    @Override
    public void connectMasterToRemainingNode(World world, List<BlockPos> alreadyChecked, IMasterRoutingNode master) {
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public List<BlockPos> getConnected() {
        return new LinkedList<BlockPos>();
    }

    @Override
    public BlockPos getMasterPos() {
        return this.func_174877_v();
    }

    @Override
    public boolean isMaster(IMasterRoutingNode master) {
        return false;
    }

    @Override
    public void addConnection(BlockPos pos1) {
    }

    @Override
    public void removeConnection(BlockPos pos1) {
        this.generalNodeList.remove(pos1);
        this.inputNodeList.remove(pos1);
        this.outputNodeList.remove(pos1);
    }

    @Override
    public void removeAllConnections() {
        List<BlockPos> list = this.generalNodeList.subList(0, this.generalNodeList.size());
        Iterator<BlockPos> itr = list.iterator();
        while (itr.hasNext()) {
            BlockPos testPos = itr.next();
            TileEntity tile = this.func_145831_w().func_175625_s(testPos);
            if (tile instanceof IRoutingNode) {
                ((IRoutingNode)tile).removeConnection(this.field_174879_c);
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(testPos), this.func_145831_w().func_180495_p(testPos), 3);
            }
            itr.remove();
            this.inputNodeList.remove(testPos);
            this.outputNodeList.remove(testPos);
        }
    }
}

