/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.potion;

import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.event.SacrificeKnifeUsedEvent;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="bloodmagic")
public class PotionEventHandlers {
    public static Map<World, List<EntityPlayer>> flightListMap = new HashMap<World, List<EntityPlayer>>();
    public static Map<World, List<EntityLivingBase>> noGravityListMap = new HashMap<World, List<EntityLivingBase>>();

    @SubscribeEvent
    public static void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase eventEntityLiving = event.getEntityLiving();
        if (eventEntityLiving.func_70644_a(RegistrarBloodMagic.BOOST)) {
            int i = eventEntityLiving.func_70660_b(RegistrarBloodMagic.BOOST).func_76458_c();
            eventEntityLiving.field_70181_x += (double)(0.1f * (float)(2 + i));
        }
        if (eventEntityLiving.func_70644_a(RegistrarBloodMagic.GROUNDED)) {
            eventEntityLiving.field_70181_x = 0.0;
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        EntityLivingBase eventEntityLiving = event.getEntityLiving();
        if (eventEntityLiving.func_70644_a(RegistrarBloodMagic.HEAVY_HEART)) {
            int i = eventEntityLiving.func_70660_b(RegistrarBloodMagic.HEAVY_HEART).func_76458_c() + 1;
            event.setDamageMultiplier(event.getDamageMultiplier() + (float)i);
            event.setDistance(event.getDistance() + (float)i);
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PotionEffect activeEffect;
        List<EntityLivingBase> noGravityList;
        EntityLivingBase eventEntityLiving = event.getEntityLiving();
        List<EntityPlayer> flightList = flightListMap.getOrDefault(eventEntityLiving.func_130014_f_(), Lists.newArrayList());
        if (eventEntityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)eventEntityLiving;
            if (!player.field_70170_p.field_72995_K) {
                if (player.func_70644_a(RegistrarBloodMagic.FLIGHT)) {
                    if (!player.func_175149_v() && !player.field_71075_bZ.field_75101_c) {
                        player.field_71075_bZ.field_75101_c = true;
                        player.func_71016_p();
                        flightList.add(player);
                    }
                } else if (flightList.contains(player)) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                    flightList.remove(player);
                }
            }
        }
        if (event.getEntityLiving().func_70644_a(RegistrarBloodMagic.BOOST)) {
            boolean isPlayerAndFlying;
            int amplifier = event.getEntityLiving().func_70660_b(RegistrarBloodMagic.BOOST).func_76458_c();
            float percentIncrease = (float)(amplifier + 1) * 0.5f;
            boolean bl = isPlayerAndFlying = eventEntityLiving instanceof EntityPlayer && ((EntityPlayer)eventEntityLiving).field_71075_bZ.field_75100_b;
            if (percentIncrease != 0.0f && (eventEntityLiving.field_70122_E || isPlayerAndFlying) && (eventEntityLiving.field_191988_bg != 0.0f || eventEntityLiving.field_70702_br != 0.0f || eventEntityLiving.field_70181_x != 0.0)) {
                eventEntityLiving.func_191986_a(eventEntityLiving.field_70702_br * percentIncrease, isPlayerAndFlying ? eventEntityLiving.field_70701_bs * percentIncrease : 0.0f, eventEntityLiving.field_191988_bg * percentIncrease);
                if (isPlayerAndFlying && eventEntityLiving.field_70181_x != 0.0) {
                    eventEntityLiving.field_70181_x *= (double)(1.0f + Math.min(percentIncrease, 0.75f));
                }
            }
        }
        if ((noGravityList = noGravityListMap.getOrDefault(event.getEntityLiving().func_130014_f_(), Lists.newArrayList())) != null) {
            if (eventEntityLiving.func_70644_a(RegistrarBloodMagic.SUSPENDED) && !eventEntityLiving.func_189652_ae()) {
                eventEntityLiving.func_189654_d(true);
                noGravityList.add(eventEntityLiving);
            } else if (noGravityList.contains(eventEntityLiving)) {
                eventEntityLiving.func_189654_d(false);
                noGravityList.remove(eventEntityLiving);
            }
        }
        if (eventEntityLiving.func_70644_a(RegistrarBloodMagic.GROUNDED) && (activeEffect = eventEntityLiving.func_70660_b(RegistrarBloodMagic.GROUNDED)) != null) {
            eventEntityLiving.field_70181_x = eventEntityLiving instanceof EntityPlayer && ((EntityPlayer)eventEntityLiving).field_71075_bZ.field_75100_b ? (eventEntityLiving.field_70181_x -= (0.05 * (double)activeEffect.func_76458_c() + 1.0 - eventEntityLiving.field_70181_x) * 0.2) : (eventEntityLiving.field_70181_x -= (0.1 * (double)activeEffect.func_76458_c() + 1.0 - eventEntityLiving.field_70181_x) * 0.2);
        }
        if (eventEntityLiving.func_70644_a(RegistrarBloodMagic.WHIRLWIND)) {
            int d0 = 3;
            AxisAlignedBB axisAlignedBB = new AxisAlignedBB(eventEntityLiving.field_70165_t - 0.5, eventEntityLiving.field_70163_u - 0.5, eventEntityLiving.field_70161_v - 0.5, eventEntityLiving.field_70165_t + 0.5, eventEntityLiving.field_70163_u + 0.5, eventEntityLiving.field_70161_v + 0.5).func_72321_a((double)d0, (double)d0, (double)d0);
            List entityList = eventEntityLiving.func_130014_f_().func_72872_a(Entity.class, axisAlignedBB);
            for (Entity projectile : entityList) {
                if (projectile == null || !(projectile instanceof IProjectile)) continue;
                Entity throwingEntity = null;
                if (projectile instanceof EntityArrow) {
                    throwingEntity = ((EntityArrow)projectile).field_70250_c;
                } else if (projectile instanceof EntityThrowable) {
                    throwingEntity = ((EntityThrowable)projectile).func_85052_h();
                }
                if (throwingEntity != null && throwingEntity.equals((Object)eventEntityLiving)) continue;
                double delX = projectile.field_70165_t - eventEntityLiving.field_70165_t;
                double delY = projectile.field_70163_u - eventEntityLiving.field_70163_u;
                double delZ = projectile.field_70161_v - eventEntityLiving.field_70161_v;
                double angle = (delX * projectile.field_70159_w + delY * projectile.field_70181_x + delZ * projectile.field_70179_y) / (Math.sqrt(delX * delX + delY * delY + delZ * delZ) * Math.sqrt(projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y));
                if ((angle = Math.acos(angle)) < 2.356194490192345) continue;
                if (throwingEntity != null) {
                    delX = -projectile.field_70165_t + throwingEntity.field_70165_t;
                    delY = -projectile.field_70163_u + (throwingEntity.field_70163_u + (double)throwingEntity.func_70047_e());
                    delZ = -projectile.field_70161_v + throwingEntity.field_70161_v;
                }
                double curVel = Math.sqrt(delX * delX + delY * delY + delZ * delZ);
                double newVel = Math.sqrt(projectile.field_70159_w * projectile.field_70159_w + projectile.field_70181_x * projectile.field_70181_x + projectile.field_70179_y * projectile.field_70179_y);
                projectile.field_70159_w = newVel * (delX /= curVel);
                projectile.field_70181_x = newVel * (delY /= curVel);
                projectile.field_70179_y = newVel * (delZ /= curVel);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getEntityPlayer().func_70690_d(new PotionEffect(RegistrarBloodMagic.SOUL_FRAY, 400));
        }
    }

    @SubscribeEvent
    public static void onSacrificeKnifeUsed(SacrificeKnifeUsedEvent event) {
        if (event.player.func_70644_a(RegistrarBloodMagic.SOUL_FRAY)) {
            event.lpAdded = (int)((double)event.lpAdded * 0.1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDamageEvent(LivingAttackEvent event) {
        if (event.getEntityLiving().func_70644_a(RegistrarBloodMagic.WHIRLWIND) && event.isCancelable() && event.getSource().func_76352_a()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEndermanTeleportEvent(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70644_a(RegistrarBloodMagic.PLANAR_BINDING) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityHurtEvent(LivingDamageEvent event) {
        if (event.getSource() == DamageSource.field_76379_h && event.getEntityLiving().func_70644_a(RegistrarBloodMagic.FEATHERED)) {
            event.setCanceled(true);
        }
    }
}

