/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.altar.AltarComponent;
import WayofTime.bloodmagic.altar.AltarTier;
import WayofTime.bloodmagic.altar.AltarUtil;
import WayofTime.bloodmagic.altar.ComponentType;
import WayofTime.bloodmagic.altar.IAltarManipulator;
import WayofTime.bloodmagic.altar.IBloodAltar;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.block.BlockAltar;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.util.helper.NBTHelper;
import WayofTime.bloodmagic.util.helper.NumeralHelper;
import WayofTime.bloodmagic.util.helper.TextHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAltarMaker
extends Item
implements IAltarManipulator,
IVariantProvider {
    private AltarTier tierToBuild = AltarTier.ONE;

    public ItemAltarMaker() {
        this.func_77655_b("bloodmagic.altarMaker");
        this.func_77637_a(BloodMagic.TAB_BM);
        this.func_77625_d(1);
        this.func_77664_n();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        tooltip.add(TextHelper.localizeEffect("tooltip.bloodmagic.currentTier", stack.func_77978_p().func_74762_e("currentTier") + 1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.altarMaker.creativeOnly", new Object[0]), true);
            return super.func_77659_a(world, player, hand);
        }
        stack = NBTHelper.checkNBT(stack);
        if (player.func_70093_af()) {
            if (stack.func_77978_p().func_74762_e("currentTier") >= AltarTier.MAXTIERS - 1) {
                stack.func_77978_p().func_74768_a("currentTier", 0);
            } else {
                stack.func_77978_p().func_74768_a("currentTier", stack.func_77978_p().func_74762_e("currentTier") + 1);
            }
            this.setTierToBuild(AltarTier.values()[stack.func_77978_p().func_74762_e("currentTier")]);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.altarMaker.setTier", new Object[]{NumeralHelper.toRoman(stack.func_77978_p().func_74762_e("currentTier") + 1)}), true);
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        if (rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return super.func_77659_a(world, player, hand);
        }
        IBlockState state = world.func_180495_p(rayTrace.func_178782_a());
        if (state.func_177230_c() instanceof BlockAltar) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.bloodmagic.altarMaker.building", new Object[]{NumeralHelper.toRoman(this.tierToBuild.toInt())}), true);
            this.buildAltar(world, rayTrace.func_178782_a());
            world.func_184138_a(rayTrace.func_178782_a(), state, state, 3);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public void gatherVariants(@Nonnull Int2ObjectMap<String> variants) {
        variants.put(0, (Object)"type=altarmaker");
    }

    public void setTierToBuild(AltarTier tierToBuild) {
        this.tierToBuild = tierToBuild;
    }

    public void buildAltar(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (this.tierToBuild == AltarTier.ONE) {
            return;
        }
        for (AltarComponent altarComponent : this.tierToBuild.getAltarComponents()) {
            BlockPos componentPos = pos.func_177971_a((Vec3i)altarComponent.getOffset());
            if (altarComponent.getComponent() == ComponentType.NOTAIR) {
                world.func_175656_a(componentPos, Blocks.field_150417_aV.func_176223_P());
                continue;
            }
            world.func_175656_a(componentPos, BloodMagicAPI.INSTANCE.getComponentStates(altarComponent.getComponent()).get(0));
        }
        ((IBloodAltar)world.func_175625_s(pos)).checkTier();
    }

    public String destroyAltar(EntityPlayer player) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return "";
        }
        RayTraceResult rayTrace = this.func_77621_a(world, player, false);
        BlockPos pos = rayTrace.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        AltarTier altarTier = AltarUtil.getTier(world, pos);
        if (altarTier.equals((Object)AltarTier.ONE)) {
            return "" + altarTier.toInt();
        }
        for (AltarComponent altarComponent : altarTier.getAltarComponents()) {
            BlockPos componentPos = pos.func_177971_a((Vec3i)altarComponent.getOffset());
            world.func_175698_g(componentPos);
        }
        world.func_184138_a(pos, state, state, 3);
        return String.valueOf(altarTier.toInt());
    }
}

