/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.client.render.block;

import WayofTime.bloodmagic.altar.AltarComponent;
import WayofTime.bloodmagic.altar.AltarTier;
import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.client.render.block.RenderFakeBlocks;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.handler.event.ClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RenderAltar
extends TileEntitySpecialRenderer<TileAltar> {
    private static final float MIN_HEIGHT = 0.499f;
    private static final float MAX_HEIGHT = 0.745f;

    public void render(TileAltar tileAltar, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        ItemStack inputStack = tileAltar.func_70301_a(0);
        float level = (float)tileAltar.getCurrentBlood() / (float)tileAltar.getCapacity();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (level > 0.0f) {
            this.renderFluid(level);
        }
        this.renderItem(inputStack);
        GlStateManager.func_179121_F();
        if (tileAltar.getCurrentTierDisplayed() != AltarTier.ONE) {
            this.renderHologram(tileAltar, tileAltar.getCurrentTierDisplayed(), partialTicks);
        }
    }

    private void renderFluid(float fluidLevel) {
        GlStateManager.func_179094_E();
        Fluid fluid = BlockLifeEssence.getLifeEssence();
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        GlStateManager.func_179137_b((double)0.5, (double)(0.499f + fluidLevel * 0.24599999f), (double)0.5);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        float size = 0.8f;
        TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getStill().toString());
        int fluidColor = fluid.getColor(fluidStack);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderAltar.setGLColorFromInt(fluidColor);
        double uMin = fluidStillSprite.func_94209_e();
        double uMax = fluidStillSprite.func_94212_f();
        double vMin = fluidStillSprite.func_94206_g();
        double vMax = fluidStillSprite.func_94210_h();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)(size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMax, vMax).func_181675_d();
        wr.func_181662_b((double)(size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMax, vMin).func_181675_d();
        wr.func_181662_b((double)(-size / 2.0f), 0.0, (double)(-size / 2.0f)).func_187315_a(uMin, vMin).func_181675_d();
        wr.func_181662_b((double)(-size / 2.0f), 0.0, (double)(size / 2.0f)).func_187315_a(uMin, vMax).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void renderItem(ItemStack stack) {
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        if (!stack.func_190926_b()) {
            GlStateManager.func_179137_b((double)0.5, (double)1.0, (double)0.5);
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            float rotation = (float)(720.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.GROUND);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    private void renderHologram(TileAltar altar, AltarTier tier, float partialTicks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.field_70170_p;
        if (tier == AltarTier.ONE) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6125f);
        BlockPos vec3 = altar.func_174877_v();
        double posX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double posY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double posZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        for (AltarComponent altarComponent : tier.getAltarComponents()) {
            BlockPos vX = vec3.func_177971_a((Vec3i)altarComponent.getOffset());
            double minX = (double)vX.func_177958_n() - posX;
            double minY = (double)vX.func_177956_o() - posY;
            double minZ = (double)vX.func_177952_p() - posZ;
            if (world.func_180495_p(vX).func_185914_p()) continue;
            TextureAtlasSprite texture = null;
            switch (altarComponent.getComponent()) {
                case BLOODRUNE: {
                    texture = ClientHandler.blankBloodRune;
                    break;
                }
                case NOTAIR: {
                    texture = ClientHandler.stoneBrick;
                    break;
                }
                case GLOWSTONE: {
                    texture = ClientHandler.glowstone;
                    break;
                }
                case BLOODSTONE: {
                    texture = ClientHandler.bloodStoneBrick;
                    break;
                }
                case BEACON: {
                    texture = ClientHandler.beacon;
                    break;
                }
                case CRYSTAL: {
                    texture = ClientHandler.crystalCluster;
                }
            }
            RenderFakeBlocks.drawFakeBlock(texture, minX, minY, minZ);
        }
        GlStateManager.func_179121_F();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

