/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.impl;

import WayofTime.bloodmagic.api.IBloodMagicRecipeRegistrar;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyArray;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyTable;
import WayofTime.bloodmagic.api.impl.recipe.RecipeBloodAltar;
import WayofTime.bloodmagic.api.impl.recipe.RecipeSacrificeCraft;
import WayofTime.bloodmagic.api.impl.recipe.RecipeTartaricForge;
import WayofTime.bloodmagic.core.recipe.IngredientBloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;

public class BloodMagicRecipeRegistrar
implements IBloodMagicRecipeRegistrar {
    private final Set<RecipeBloodAltar> altarRecipes = Sets.newHashSet();
    private final Set<RecipeAlchemyTable> alchemyRecipes = Sets.newHashSet();
    private final Set<RecipeTartaricForge> tartaricForgeRecipes = Sets.newHashSet();
    private final Set<RecipeAlchemyArray> alchemyArrayRecipes = Sets.newHashSet();
    private final Set<RecipeSacrificeCraft> sacrificeCraftRecipes = Sets.newHashSet();

    @Override
    public void addBloodAltar(@Nonnull Ingredient input, @Nonnull ItemStack output, @Nonnegative int minimumTier, @Nonnegative int syphon, @Nonnegative int consumeRate, @Nonnegative int drainRate) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((consumeRate >= 0 ? 1 : 0) != 0, (Object)"consumeRate cannot be negative.");
        Preconditions.checkArgument((drainRate >= 0 ? 1 : 0) != 0, (Object)"drainRate cannot be negative.");
        this.altarRecipes.add(new RecipeBloodAltar(input, output, minimumTier, syphon, consumeRate, drainRate));
    }

    @Override
    public boolean removeBloodAltar(@Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        return this.altarRecipes.remove(this.getBloodAltar(input));
    }

    @Override
    public void addAlchemyTable(@Nonnull ItemStack output, @Nonnegative int syphon, @Nonnegative int ticks, @Nonnegative int minimumTier, Ingredient ... input) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be negative.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])input);
        this.alchemyRecipes.add(new RecipeAlchemyTable((NonNullList<Ingredient>)inputs, output, syphon, ticks, minimumTier));
    }

    public void addAlchemyTable(@Nonnull ItemStack output, @Nonnegative int syphon, @Nonnegative int ticks, @Nonnegative int minimumTier, Object ... input) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((syphon >= 0 ? 1 : 0) != 0, (Object)"syphon cannot be negative.");
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be negative.");
        Preconditions.checkArgument((minimumTier >= 0 ? 1 : 0) != 0, (Object)"minimumTier cannot be negative.");
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        ArrayList ingredients = Lists.newArrayList();
        for (Object object : input) {
            if (object instanceof ItemStack && ((ItemStack)object).func_77973_b() instanceof IBloodOrb) {
                ingredients.add(new IngredientBloodOrb(((IBloodOrb)((ItemStack)object).func_77973_b()).getOrb((ItemStack)object)));
                continue;
            }
            ingredients.add(CraftingHelper.getIngredient((Object)object));
        }
        this.addAlchemyTable(output, syphon, ticks, minimumTier, ingredients.toArray(new Ingredient[0]));
    }

    public void addAlchemyTable(RecipeAlchemyTable recipe) {
        this.alchemyRecipes.add(recipe);
    }

    @Override
    public boolean removeAlchemyTable(ItemStack ... input) {
        Preconditions.checkNotNull((Object)input, (Object)"inputs cannot be null.");
        for (ItemStack stack : input) {
            Preconditions.checkNotNull((Object)stack, (Object)"input cannot be null.");
        }
        return this.alchemyRecipes.remove(this.getAlchemyTable(Lists.newArrayList((Object[])input)));
    }

    @Override
    public void addTartaricForge(@Nonnull ItemStack output, @Nonnegative double minimumSouls, @Nonnegative double soulDrain, Ingredient ... input) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumSouls >= 0.0 ? 1 : 0) != 0, (Object)"minimumSouls cannot be negative.");
        Preconditions.checkArgument((soulDrain >= 0.0 ? 1 : 0) != 0, (Object)"soulDrain cannot be negative.");
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])input);
        this.tartaricForgeRecipes.add(new RecipeTartaricForge((NonNullList<Ingredient>)inputs, output, minimumSouls, soulDrain));
    }

    @Override
    public boolean removeTartaricForge(ItemStack ... input) {
        Preconditions.checkNotNull((Object)input, (Object)"inputs cannot be null.");
        for (ItemStack stack : input) {
            Preconditions.checkNotNull((Object)stack, (Object)"input cannot be null.");
        }
        return this.tartaricForgeRecipes.remove(this.getTartaricForge(Lists.newArrayList((Object[])input)));
    }

    public void addTartaricForge(@Nonnull ItemStack output, @Nonnegative double minimumSouls, @Nonnegative double soulDrain, Object ... input) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((minimumSouls >= 0.0 ? 1 : 0) != 0, (Object)"minimumSouls cannot be negative.");
        Preconditions.checkArgument((soulDrain >= 0.0 ? 1 : 0) != 0, (Object)"soulDrain cannot be negative.");
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        ArrayList ingredients = Lists.newArrayList();
        for (Object object : input) {
            if (object instanceof ItemStack && ((ItemStack)object).func_77973_b() instanceof IBloodOrb) {
                ingredients.add(new IngredientBloodOrb(((IBloodOrb)((ItemStack)object).func_77973_b()).getOrb((ItemStack)object)));
                continue;
            }
            ingredients.add(CraftingHelper.getIngredient((Object)object));
        }
        this.addTartaricForge(output, minimumSouls, soulDrain, ingredients.toArray(new Ingredient[0]));
    }

    @Override
    public void addAlchemyArray(@Nonnull Ingredient input, @Nonnull Ingredient catalyst, @Nonnull ItemStack output, @Nullable ResourceLocation circleTexture) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)catalyst, (Object)"catalyst cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        this.alchemyArrayRecipes.add(new RecipeAlchemyArray(input, catalyst, output, circleTexture));
    }

    @Override
    public boolean removeAlchemyArray(@Nonnull ItemStack input, @Nonnull ItemStack catalyst) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)catalyst, (Object)"catalyst cannot be null.");
        return this.alchemyArrayRecipes.remove(this.getAlchemyArray(input, catalyst));
    }

    public void addAlchemyArray(@Nonnull ItemStack input, @Nonnull ItemStack catalyst, @Nonnull ItemStack output, @Nullable ResourceLocation circleTexture) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        Preconditions.checkNotNull((Object)catalyst, (Object)"catalyst cannot be null.");
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        this.addAlchemyArray(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{catalyst}), output, circleTexture);
    }

    public void addSacrificeCraft(@Nonnull ItemStack output, @Nonnegative double healthRequired, Object ... input) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((healthRequired >= 0.0 ? 1 : 0) != 0, (Object)"healthRequired cannot be negative.");
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        ArrayList ingredients = Lists.newArrayList();
        for (Object object : input) {
            if (object instanceof ItemStack && ((ItemStack)object).func_77973_b() instanceof IBloodOrb) {
                ingredients.add(new IngredientBloodOrb(((IBloodOrb)((ItemStack)object).func_77973_b()).getOrb((ItemStack)object)));
                continue;
            }
            ingredients.add(CraftingHelper.getIngredient((Object)object));
        }
        this.addSacrificeCraft(output, healthRequired, ingredients.toArray(new Ingredient[0]));
    }

    @Override
    public boolean removeSacrificeCraft(ItemStack ... input) {
        Preconditions.checkNotNull((Object)input, (Object)"inputs cannot be null.");
        for (ItemStack stack : input) {
            Preconditions.checkNotNull((Object)stack, (Object)"input cannot be null.");
        }
        return this.sacrificeCraftRecipes.remove(this.getSacrificeCraft(Lists.newArrayList((Object[])input)));
    }

    @Override
    public void addSacrificeCraft(@Nonnull ItemStack output, @Nonnegative double healthRequired, Ingredient ... input) {
        Preconditions.checkNotNull((Object)output, (Object)"output cannot be null.");
        Preconditions.checkArgument((healthRequired >= 0.0 ? 1 : 0) != 0, (Object)"healthRequired cannot be negative.");
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        NonNullList inputs = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])input);
        this.sacrificeCraftRecipes.add(new RecipeSacrificeCraft((NonNullList<Ingredient>)inputs, output, healthRequired));
    }

    @Nullable
    public RecipeBloodAltar getBloodAltar(@Nonnull ItemStack input) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.func_190926_b()) {
            return null;
        }
        for (RecipeBloodAltar recipe : this.altarRecipes) {
            if (!recipe.getInput().test((Object)input)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeAlchemyTable getAlchemyTable(@Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        block0: for (RecipeAlchemyTable recipe : this.alchemyRecipes) {
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.apply(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeTartaricForge getTartaricForge(@Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        block0: for (RecipeTartaricForge recipe : this.tartaricForgeRecipes) {
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.apply(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeSacrificeCraft getSacrificeCraft(@Nonnull List<ItemStack> input) {
        Preconditions.checkNotNull(input, (Object)"input cannot be null.");
        if (input.isEmpty()) {
            return null;
        }
        block0: for (RecipeSacrificeCraft recipe : this.sacrificeCraftRecipes) {
            if (recipe.getInput().size() != input.size()) continue;
            ArrayList<Ingredient> recipeInput = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.getInput());
            for (int i = 0; i < input.size(); ++i) {
                boolean matched = false;
                for (int j = 0; j < recipeInput.size(); ++j) {
                    Ingredient ingredient = (Ingredient)recipeInput.get(j);
                    if (!ingredient.apply(input.get(i))) continue;
                    matched = true;
                    recipeInput.remove(j);
                    break;
                }
                if (!matched) continue block0;
            }
            return recipe;
        }
        return null;
    }

    @Nullable
    public RecipeAlchemyArray getAlchemyArray(@Nonnull ItemStack input, @Nonnull ItemStack catalyst) {
        Preconditions.checkNotNull((Object)input, (Object)"input cannot be null.");
        if (input.func_190926_b()) {
            return null;
        }
        for (RecipeAlchemyArray recipe : this.alchemyArrayRecipes) {
            if (!recipe.getInput().test((Object)input) || !recipe.getCatalyst().test((Object)catalyst)) continue;
            return recipe;
        }
        return null;
    }

    public Set<RecipeBloodAltar> getAltarRecipes() {
        return ImmutableSet.copyOf(this.altarRecipes);
    }

    public Set<RecipeAlchemyTable> getAlchemyRecipes() {
        return ImmutableSet.copyOf(this.alchemyRecipes);
    }

    public Set<RecipeTartaricForge> getTartaricForgeRecipes() {
        return ImmutableSet.copyOf(this.tartaricForgeRecipes);
    }

    public Set<RecipeAlchemyArray> getAlchemyArrayRecipes() {
        return ImmutableSet.copyOf(this.alchemyArrayRecipes);
    }
}

